/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class VortexEntity
extends ThrowableProjectile {
    private int hitCounter = 0;
    private float renderOffsetX = -3.4028235E38f;
    private static int lastPlayerBoost;

    public VortexEntity(EntityType<? extends VortexEntity> type, Level world) {
        super(type, world);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            BlockPos.betweenClosedStream((AABB)this.getBoundingBox()).filter(pos -> this.vortexBreakable(this.level(), (BlockPos)pos)).forEach(this::handleVortexCollision);
        }
        this.setDeltaMovement(this.getDeltaMovement().scale(0.99));
        if (this.getDeltaMovement().lengthSqr() < 0.1) {
            this.discard();
        }
    }

    public boolean hasRenderOffsetX() {
        return this.renderOffsetX > -3.4028235E38f;
    }

    public float getRenderOffsetX() {
        return this.renderOffsetX;
    }

    public void setRenderOffsetX(float renderOffsetX) {
        this.renderOffsetX = renderOffsetX;
    }

    public boolean isNoGravity() {
        return true;
    }

    protected void onHit(HitResult hitResult) {
        if (hitResult instanceof EntityHitResult) {
            Player player;
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            Entity entity = entityHitResult.getEntity();
            if (entity instanceof Player && (!(player = (Player)entity).level().isClientSide() || this.boostedRecently(player))) {
                return;
            }
            entity.setDeltaMovement(entity.getDeltaMovement().add(this.getDeltaMovement().add(0.0, 0.4, 0.0)));
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                Entity entity2 = this.getOwner();
                if (entity2 instanceof Player) {
                    Player shooter = (Player)entity2;
                    ItemStack shears = new ItemStack((ItemLike)Items.SHEARS);
                    shears.getItem().interactLivingEntity(shears, shooter, livingEntity, InteractionHand.MAIN_HAND);
                }
            }
        } else if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            BlockPos pos = blockHitResult.getBlockPos();
            if (this.vortexBreakable(this.level(), pos)) {
                if (!this.level().isClientSide) {
                    this.handleVortexCollision(pos);
                }
            } else {
                this.discard();
            }
        }
        if (++this.hitCounter > 20) {
            this.discard();
        }
    }

    private boolean boostedRecently(Player player) {
        if (player.tickCount - lastPlayerBoost < 20) {
            return true;
        }
        lastPlayerBoost = player.tickCount;
        return false;
    }

    private void handleVortexCollision(BlockPos pos) {
        this.level().destroyBlock(pos, true);
        this.setDeltaMovement(this.getDeltaMovement().scale(0.85));
    }

    private boolean vortexBreakable(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return !state.isAir() && state.getDestroySpeed((BlockGetter)level, pos) == 0.0f || state.getBlock() instanceof LeavesBlock || state.getBlock() instanceof WebBlock || state.getBlock() instanceof SnowLayerBlock;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }
}

