/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIDig;
import me.desht.pneumaticcraft.common.drone.progwidgets.IBlockOrdered;
import me.desht.pneumaticcraft.common.drone.progwidgets.IMaxActions;
import me.desht.pneumaticcraft.common.drone.progwidgets.IToolUser;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetDigAndPlace;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;

public class ProgWidgetDig
extends ProgWidgetDigAndPlace
implements IToolUser {
    public static final MapCodec<ProgWidgetDig> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetDig.digPlaceParts(builder).and((App)Codec.BOOL.optionalFieldOf("require_tool", (Object)false).forGetter(ProgWidgetDig::requiresTool)).apply((Applicative)builder, ProgWidgetDig::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetDig> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetDigAndPlace.DigPlaceFields.STREAM_CODEC, p -> p.digPlaceFields, (StreamCodec)ByteBufCodecs.BOOL, ProgWidgetDig::requiresTool, ProgWidgetDig::new);
    private boolean requireDiggingTool;

    public ProgWidgetDig(ProgWidget.PositionFields pos, ProgWidgetDigAndPlace.DigPlaceFields digPlaceFields, boolean requireDiggingTool) {
        super(pos, digPlaceFields);
        this.requireDiggingTool = requireDiggingTool;
    }

    public ProgWidgetDig() {
        super(ProgWidget.PositionFields.DEFAULT, ProgWidgetDigAndPlace.DigPlaceFields.makeDefault(IBlockOrdered.Ordering.CLOSEST));
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetDig(this.getPosition(), this.digPlaceFields, this.requireDiggingTool);
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_DIG;
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        return this.setupMaxActions(new DroneAIDig<ProgWidgetAreaItemBase>(drone, (ProgWidgetAreaItemBase)widget), (IMaxActions)((Object)widget));
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.BROWN;
    }

    @Override
    public boolean requiresTool() {
        return this.requireDiggingTool;
    }

    @Override
    public void setRequiresTool(boolean requireDiggingTool) {
        this.requireDiggingTool = requireDiggingTool;
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.DIG.get();
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        if (this.requiresTool()) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.dig.requiresDiggingTool", new Object[0]));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgWidgetDig that = (ProgWidgetDig)o;
        return this.baseEquals(that) && this.requireDiggingTool == that.requireDiggingTool;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.requireDiggingTool);
    }
}

