/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.FluidTankBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IComparatorSupport;
import me.desht.pneumaticcraft.common.block.entity.ISerializableTanks;
import me.desht.pneumaticcraft.common.block.entity.SmartSyncTank;
import me.desht.pneumaticcraft.common.inventory.FluidTankMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public abstract class AbstractFluidTankBlockEntity
extends AbstractTickingBlockEntity
implements ISerializableTanks,
MenuProvider,
IComparatorSupport {
    private static final int INVENTORY_SIZE = 2;
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private static final int BASE_EJECT_RATE = 25;
    @LazySynced
    @DescSynced
    @GuiSynced
    private final StackableTank tank;
    private final ItemStackHandler inventory = new BaseItemStackHandler(this, this, 2){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.isEmpty() || FluidUtil.getFluidHandler((ItemStack)itemStack).isPresent();
        }
    };

    AbstractFluidTankBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, FluidTankBlock.Size tankSize) {
        super(type, pos, state, 4);
        this.tank = new StackableTank(tankSize.getCapacity());
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.tank.tick();
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.processFluidItem(0, 1);
        FluidStack stack = this.getTank().getFluid();
        if (!stack.isEmpty()) {
            BlockEntity blockEntity;
            BlockState other;
            Direction dir;
            Direction direction = dir = stack.getFluid().getFluidType().isLighterThanAir() ? Direction.UP : Direction.DOWN;
            if (((Boolean)this.getBlockState().getValue((Property)AbstractPneumaticCraftBlock.connectionProperty(dir))).booleanValue() && (other = this.nonNullLevel().getBlockState(this.worldPosition.relative(dir))).getBlock() instanceof FluidTankBlock && ((Boolean)other.getValue((Property)AbstractPneumaticCraftBlock.connectionProperty(dir.getOpposite()))).booleanValue() && (blockEntity = this.getCachedNeighbor(dir)) instanceof AbstractFluidTankBlockEntity) {
                AbstractFluidTankBlockEntity tankBE = (AbstractFluidTankBlockEntity)blockEntity;
                FluidUtil.tryFluidTransfer((IFluidHandler)tankBE.getTank(), (IFluidHandler)this.tank, (int)(this.tank.getCapacity() / 32), (boolean)true);
            }
        }
        this.getUpgradeCache().getEjectDirection().ifPresent(ejectDir -> {
            if (ejectDir.getAxis() != Direction.Axis.Y || !((Boolean)this.getBlockState().getValue((Property)AbstractPneumaticCraftBlock.connectionProperty(ejectDir))).booleanValue()) {
                IOHelper.getFluidHandlerForBlock(this.getCachedNeighbor((Direction)ejectDir), ejectDir.getOpposite()).ifPresent(h -> {
                    int amount = 25 << this.getUpgrades(ModUpgrades.SPEED.get());
                    FluidUtil.tryFluidTransfer((IFluidHandler)h, (IFluidHandler)this.tank, (int)amount, (boolean)true);
                });
            }
        });
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return this.inventory;
    }

    @Override
    public boolean hasFluidCapability() {
        return true;
    }

    @Override
    public IFluidHandler getFluidHandler(@Nullable Direction dir) {
        return this.tank;
    }

    @Override
    @Nonnull
    public Map<DataComponentType<SimpleFluidContent>, PNCFluidTank> getSerializableTanks() {
        return Map.of(ModDataComponents.MAIN_TANK.get(), this.tank);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("Items", (Tag)this.inventory.serializeNBT(provider));
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.inventory.deserializeNBT(provider, tag.getCompound("Items"));
    }

    public SmartSyncTank getTank() {
        return this.tank;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
        return new FluidTankMenu(windowId, inv, this.getBlockPos());
    }

    public boolean isNeighbourCompatible(FluidStack stack, Direction dir) {
        BlockState state = this.getBlockState();
        AbstractFluidTankBlockEntity curTank = this;
        while (state.getBlock() instanceof FluidTankBlock) {
            if (!((Boolean)state.getValue((Property)AbstractPneumaticCraftBlock.connectionProperty(dir))).booleanValue()) {
                return true;
            }
            BlockEntity teOther = curTank.getCachedNeighbor(dir);
            if (teOther instanceof AbstractFluidTankBlockEntity) {
                curTank = (AbstractFluidTankBlockEntity)teOther;
                state = curTank.getBlockState();
                if (this.isFluidCompatible(stack, curTank.getTank())) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public boolean isFluidCompatible(FluidStack stack, IFluidTank tank) {
        return stack.isEmpty() || tank.getFluid().isEmpty() || stack.getFluid() == tank.getFluid().getFluid();
    }

    @Override
    public int getComparatorValue() {
        return this.tank.isEmpty() ? 0 : 1 + this.tank.getFluidAmount() * 14 / this.tank.getCapacity();
    }

    public class StackableTank
    extends SmartSyncTank {
        StackableTank(int capacity) {
            super(AbstractFluidTankBlockEntity.this, capacity);
        }

        @Override
        public boolean isFluidValid(FluidStack stack) {
            return AbstractFluidTankBlockEntity.this.isNeighbourCompatible(stack, Direction.UP) && AbstractFluidTankBlockEntity.this.isNeighbourCompatible(stack, Direction.DOWN);
        }
    }

    public static class Huge
    extends AbstractFluidTankBlockEntity {
        public Huge(BlockPos pos, BlockState state) {
            super(ModBlockEntityTypes.TANK_HUGE.get(), pos, state, FluidTankBlock.Size.HUGE);
        }
    }

    public static class Large
    extends AbstractFluidTankBlockEntity {
        public Large(BlockPos pos, BlockState state) {
            super(ModBlockEntityTypes.TANK_LARGE.get(), pos, state, FluidTankBlock.Size.LARGE);
        }
    }

    public static class Medium
    extends AbstractFluidTankBlockEntity {
        public Medium(BlockPos pos, BlockState state) {
            super(ModBlockEntityTypes.TANK_MEDIUM.get(), pos, state, FluidTankBlock.Size.MEDIUM);
        }
    }

    public static class Small
    extends AbstractFluidTankBlockEntity {
        public Small(BlockPos pos, BlockState state) {
            super(ModBlockEntityTypes.TANK_SMALL.get(), pos, state, FluidTankBlock.Size.SMALL);
        }
    }
}

