/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.processing.UVLightBoxBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class UVLightBoxBlock
extends AbstractPneumaticCraftBlock
implements ColorHandlers.ITintableBlock,
PneumaticCraftEntityBlock {
    public static final BooleanProperty LOADED = BooleanProperty.create((String)"loaded");
    public static final BooleanProperty LIT = RedstoneTorchBlock.LIT;
    private static final VoxelShape SHAPE_N = Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)14.0, (double)14.0), (VoxelShape)Block.box((double)15.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_E = VoxelShapeUtils.rotateY(SHAPE_N, 90);
    private static final VoxelShape SHAPE_S = VoxelShapeUtils.rotateY(SHAPE_E, 90);
    private static final VoxelShape SHAPE_W = VoxelShapeUtils.rotateY(SHAPE_S, 90);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_E, SHAPE_S, SHAPE_W, SHAPE_N};

    public UVLightBoxBlock() {
        super(ModBlocks.defaultProps().lightLevel(state -> (Boolean)state.getValue((Property)LIT) != false ? 15 : 0));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)LOADED, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LOADED, LIT});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        Direction d = (Direction)state.getValue((Property)this.directionProperty());
        return SHAPES[d.get2DDataValue()];
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    public int getTintColor(BlockState state, @javax.annotation.Nullable BlockAndTintGetter world, @javax.annotation.Nullable BlockPos pos, int tintIndex) {
        if (world != null && pos != null) {
            return state.hasProperty((Property)LIT) && (Boolean)state.getValue((Property)LIT) != false ? -12582657 : -5263388;
        }
        return -5263388;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new UVLightBoxBlockEntity(pPos, pState);
    }
}

