/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.List;
import me.desht.pneumaticcraft.common.block.AbstractPNCBlockWithBoundingBlocks;
import me.desht.pneumaticcraft.common.block.entity.compressor.SolarCompressorBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SolarCompressorBlock
extends AbstractPNCBlockWithBoundingBlocks {
    private static final Vec3i[] BOUNDING_BLOCK_OFFSETS = new Vec3i[]{new Vec3i(0, 1, 0), new Vec3i(0, 1, 1), new Vec3i(0, 1, -1)};
    private static final VoxelShape SHAPE_S = VoxelShapeUtils.or(Block.box((double)0.0, (double)1.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0), Block.box((double)5.0, (double)16.0, (double)5.0, (double)11.0, (double)17.0, (double)11.0), Block.box((double)2.0, (double)15.0, (double)3.0, (double)3.0, (double)17.0, (double)13.0), Block.box((double)13.0, (double)15.0, (double)3.0, (double)14.0, (double)17.0, (double)13.0), Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0), Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)7.0, (double)17.0, (double)7.0, (double)9.0, (double)31.0, (double)9.0));
    protected static final VoxelShape SHAPE_W = VoxelShapeUtils.rotateY(SHAPE_S, 90);
    private static final VoxelShape SHAPE_N = VoxelShapeUtils.rotateY(SHAPE_W, 90);
    private static final VoxelShape SHAPE_E = VoxelShapeUtils.rotateY(SHAPE_N, 90);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_S, SHAPE_W, SHAPE_N, SHAPE_E};

    public SolarCompressorBlock() {
        super(ModBlocks.defaultProps());
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (((Boolean)state.getValue((Property)BOUNDING)).booleanValue()) {
            return Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        Direction d = (Direction)state.getValue((Property)this.directionProperty());
        return SHAPES[d.get2DDataValue()];
    }

    @Override
    @NotNull
    public VoxelShape getCollisionShape(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.getShape(state, world, pos, context);
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new SolarCompressorBlockEntity(pPos, pState);
    }

    @Override
    @Nullable
    public Vec3i[] getBoundingBlockOffsets() {
        return BOUNDING_BLOCK_OFFSETS;
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        SolarCompressorBlockEntity solarCompressor;
        if (((Boolean)state.getValue((Property)BOUNDING)).booleanValue()) {
            return ItemInteractionResult.FAIL;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SolarCompressorBlockEntity && (solarCompressor = (SolarCompressorBlockEntity)blockEntity).isBroken() && stack.getItem() == ModItems.SOLAR_CELL.get()) {
            if (!level.isClientSide) {
                if (!player.isCreative()) {
                    player.getMainHandItem().shrink(1);
                }
                solarCompressor.fixBroken();
                level.playSound(null, pos, SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 1.0f, 1.5f);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, brtr);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> curInfo, TooltipFlag flag) {
        super.appendHoverText(stack, context, curInfo, flag);
        if (((Boolean)stack.getOrDefault(ModDataComponents.SOLAR_BROKEN, (Object)false)).booleanValue()) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.broken", new Object[0]));
        }
    }

    @Override
    public void addSerializableComponents(List<DataComponentType<?>> list) {
        super.addSerializableComponents(list);
        list.add(ModDataComponents.SOLAR_BROKEN.get());
    }
}

