/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.List;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.utility.PneumaticDoorBaseBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.utility.PneumaticDoorBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PneumaticDoorBlock
extends AbstractPneumaticCraftBlock
implements PneumaticCraftEntityBlock {
    public static final BooleanProperty TOP_DOOR = BooleanProperty.create((String)"top_door");

    public PneumaticDoorBlock() {
        super(ModBlocks.defaultProps());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)TOP_DOOR, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TOP_DOOR, DoorBlock.OPEN});
    }

    @Override
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public static boolean isTopDoor(BlockState state) {
        return state.getBlock() == ModBlocks.PNEUMATIC_DOOR.get() && (Boolean)state.getValue((Property)TOP_DOOR) != false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.calculateVoxelShape(state, world, pos, 13);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.calculateVoxelShape(state, world, pos, 15);
    }

    private VoxelShape calculateVoxelShape(BlockState state, BlockGetter world, BlockPos pos, int thickness) {
        float xMin = 0.001f;
        float zMin = 0.001f;
        float xMax = 0.999f;
        float zMax = 0.999f;
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof PneumaticDoorBlockEntity) {
            PneumaticDoorBlockEntity door = (PneumaticDoorBlockEntity)te;
            Direction rotation = this.getRotation(state);
            float t = (float)thickness / 16.0f;
            float rads = (float)Math.toRadians(door.rotationAngle);
            float cosinus = t - Mth.sin((float)rads) * t;
            float sinus = t - Mth.cos((float)rads) * t;
            if (door.rightGoing) {
                switch (rotation) {
                    case NORTH: {
                        zMin = cosinus;
                        xMax = 1.0f - sinus;
                        break;
                    }
                    case WEST: {
                        xMin = cosinus;
                        zMin = sinus;
                        break;
                    }
                    case SOUTH: {
                        zMax = 1.0f - cosinus;
                        xMin = sinus;
                        break;
                    }
                    case EAST: {
                        xMax = 1.0f - cosinus;
                        zMax = 1.0f - sinus;
                    }
                }
            } else {
                switch (rotation) {
                    case NORTH: {
                        zMin = cosinus;
                        xMin = sinus;
                        break;
                    }
                    case WEST: {
                        xMin = 0.001f + cosinus;
                        zMax = 0.999f - sinus;
                        break;
                    }
                    case SOUTH: {
                        zMax = 1.0f - cosinus;
                        xMax = 1.0f - sinus;
                        break;
                    }
                    case EAST: {
                        xMax = 1.0f - cosinus;
                        zMin = sinus;
                    }
                }
            }
        }
        boolean topDoor = (Boolean)state.getValue((Property)TOP_DOOR);
        return Shapes.create((AABB)new AABB((double)xMin, topDoor ? -1.0 : 0.0, (double)zMin, (double)xMax, topDoor ? 1.0 : 2.0, (double)zMax));
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (((Boolean)state.getValue((Property)TOP_DOOR)).booleanValue()) {
            return world.getBlockState(pos.below()).getBlock() == this;
        }
        return world.isEmptyBlock(pos.above());
    }

    @Override
    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity par5EntityLiving, ItemStack par6ItemStack) {
        super.setPlacedBy(world, pos, state, par5EntityLiving, par6ItemStack);
        world.setBlock(pos.relative(Direction.UP), (BlockState)world.getBlockState(pos).setValue((Property)TOP_DOOR, (Comparable)Boolean.valueOf(true)), 3);
        world.getBlockEntity(pos, ModBlockEntityTypes.PNEUMATIC_DOOR.get()).ifPresent(teDoor -> {
            BlockPos top = pos.above();
            if (world.getBlockState(top.relative(this.getRotation(state).getCounterClockWise())).getBlock() == ModBlocks.PNEUMATIC_DOOR_BASE.get()) {
                teDoor.rightGoing = true;
            } else if (world.getBlockState(top.relative(this.getRotation(state).getClockWise())).getBlock() == ModBlocks.PNEUMATIC_DOOR_BASE.get()) {
                teDoor.rightGoing = false;
            }
            BlockEntity topHalf = world.getBlockEntity(top);
            if (topHalf instanceof PneumaticDoorBlockEntity) {
                PneumaticDoorBlockEntity door = (PneumaticDoorBlockEntity)topHalf;
                door.rightGoing = teDoor.rightGoing;
                door.color = teDoor.color;
            }
        });
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        BlockPos posDown = pos.below();
        BlockPos posUp = pos.above();
        if (PneumaticDoorBlock.isTopDoor(state) && worldIn.getBlockState(posDown).getBlock() == this) {
            worldIn.removeBlock(posDown, false);
        } else if (!PneumaticDoorBlock.isTopDoor(state) && worldIn.getBlockState(posUp).getBlock() == this) {
            worldIn.removeBlock(posUp, false);
        }
        return super.playerWillDestroy(worldIn, pos, state, player);
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    public boolean onWrenched(Level world, Player player, BlockPos pos, Direction face, InteractionHand hand) {
        BlockState state = world.getBlockState(pos);
        if (PneumaticDoorBlock.isTopDoor(state)) {
            return this.onWrenched(world, player, pos.relative(Direction.DOWN), face, hand);
        }
        if (player != null && player.isShiftKeyDown()) {
            if (!player.isCreative()) {
                BlockEntity te = world.getBlockEntity(pos);
                Block.dropResources((BlockState)world.getBlockState(pos), (LevelAccessor)world, (BlockPos)pos, (BlockEntity)te);
                PneumaticDoorBlock.removeBlockSneakWrenched(world, pos);
                PneumaticDoorBlock.removeBlockSneakWrenched(world, pos.above());
            }
        } else {
            super.onWrenched(world, player, pos, face, hand);
            BlockState newState = world.getBlockState(pos);
            world.setBlock(pos.relative(Direction.UP), (BlockState)newState.setValue((Property)TOP_DOOR, (Comparable)Boolean.valueOf(true)), 3);
        }
        return true;
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        DyeColor dyeColor = DyeColor.getColor((ItemStack)player.getItemInHand(hand));
        if (dyeColor != null) {
            PneumaticDoorBlockEntity teDoor;
            BlockEntity te;
            if (!world.isClientSide && (te = world.getBlockEntity(PneumaticDoorBlock.isTopDoor(state) ? pos.below() : pos)) instanceof PneumaticDoorBlockEntity && (teDoor = (PneumaticDoorBlockEntity)te).setColor(dyeColor) && ((Boolean)ConfigHelper.common().general.useUpDyesWhenColoring.get()).booleanValue()) {
                player.getItemInHand(hand).shrink(1);
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult brtr) {
        PneumaticDoorBaseBlockEntity doorBase = this.getDoorBase((BlockGetter)world, pos);
        if (!world.isClientSide && doorBase != null && doorBase.getRedstoneController().getCurrentMode() == 2 && doorBase.getPressure() >= doorBase.getMinWorkingPressure()) {
            doorBase.setOpening(!doorBase.isOpening());
            doorBase.setNeighborOpening(doorBase.isOpening());
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean powered;
        boolean bl = powered = world.getBestNeighborSignal(pos) > 0;
        if (!powered) {
            powered = world.getBestNeighborSignal(pos.relative(PneumaticDoorBlock.isTopDoor(state) ? Direction.DOWN : Direction.UP)) > 0;
        }
        PneumaticDoorBaseBlockEntity doorBase = this.getDoorBase((BlockGetter)world, pos);
        if (!world.isClientSide && doorBase != null && doorBase.getPressure() >= 2.0f && powered != doorBase.wasPowered) {
            doorBase.wasPowered = powered;
            doorBase.setOpening(powered);
            doorBase.setNeighborOpening(doorBase.isOpening());
        }
    }

    @Override
    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return (Boolean)state.getValue((Property)DoorBlock.OPEN);
    }

    private PneumaticDoorBaseBlockEntity getDoorBase(BlockGetter world, BlockPos pos) {
        PneumaticDoorBaseBlockEntity doorBase;
        PneumaticDoorBaseBlockEntity doorBase2;
        if (world.getBlockState(pos).getBlock() != this) {
            return null;
        }
        if (!PneumaticDoorBlock.isTopDoor(world.getBlockState(pos))) {
            return this.getDoorBase(world, pos.relative(Direction.UP));
        }
        Direction dir = this.getRotation(world, pos);
        if (dir.getAxis() == Direction.Axis.Y) {
            return null;
        }
        BlockEntity te1 = world.getBlockEntity(pos.relative(dir.getClockWise()));
        if (te1 instanceof PneumaticDoorBaseBlockEntity && (doorBase2 = (PneumaticDoorBaseBlockEntity)te1).getRotation() == dir.getCounterClockWise()) {
            return doorBase2;
        }
        BlockEntity te2 = world.getBlockEntity(pos.relative(dir.getCounterClockWise()));
        if (te2 instanceof PneumaticDoorBaseBlockEntity && (doorBase = (PneumaticDoorBaseBlockEntity)te2).getRotation() == dir.getClockWise()) {
            return doorBase;
        }
        return null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new PneumaticDoorBlockEntity(pPos, pState);
    }

    @Override
    public void addSerializableComponents(List<DataComponentType<?>> list) {
        super.addSerializableComponents(list);
        list.add(ModDataComponents.DOOR_COLOR.get());
    }

    public static class ItemBlockPneumaticDoor
    extends BlockItem
    implements ColorHandlers.ITintableItem {
        public ItemBlockPneumaticDoor(Block blockIn) {
            super(blockIn, ModItems.defaultProps());
        }

        @Override
        public int getTintColor(ItemStack stack, int tintIndex) {
            if (tintIndex == 0) {
                return ((DyeColor)stack.getOrDefault(ModDataComponents.DOOR_COLOR, (Object)DyeColor.WHITE)).getTextureDiffuseColor();
            }
            return -1;
        }
    }
}

