/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.common.block.AbstractCamouflageBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.PneumaticDoorBlock;
import me.desht.pneumaticcraft.common.block.entity.utility.PneumaticDoorBaseBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PneumaticDoorBaseBlock
extends AbstractCamouflageBlock
implements PneumaticCraftEntityBlock {
    private static final VoxelShape SHAPE_N = VoxelShapeUtils.or(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)12.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)14.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0), Block.box((double)0.0, (double)12.0, (double)0.0, (double)3.0, (double)16.0, (double)14.0));
    private static final VoxelShape SHAPE_E = VoxelShapeUtils.rotateY(SHAPE_N, 90);
    private static final VoxelShape SHAPE_S = VoxelShapeUtils.rotateY(SHAPE_E, 90);
    private static final VoxelShape SHAPE_W = VoxelShapeUtils.rotateY(SHAPE_S, 90);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_S, SHAPE_W, SHAPE_N, SHAPE_E};

    public PneumaticDoorBaseBlock() {
        super(ModBlocks.defaultProps().noOcclusion());
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction d = (Direction)state.getValue((Property)this.directionProperty());
        return SHAPES[d.get2DDataValue()];
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(world, pos, state, entity, stack);
        world.getBlockEntity(pos, ModBlockEntityTypes.PNEUMATIC_DOOR_BASE.get()).ifPresent(this::updateDoorSide);
    }

    @Override
    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        world.getBlockEntity(pos, ModBlockEntityTypes.PNEUMATIC_DOOR_BASE.get()).ifPresent(teDoorBase -> {
            this.updateDoorSide((PneumaticDoorBaseBlockEntity)teDoorBase);
            teDoorBase.onNeighborBlockUpdate(fromPos);
            BlockPos doorPos = pos.relative(teDoorBase.getRotation());
            BlockState doorState = world.getBlockState(doorPos);
            if (doorState.getBlock() instanceof PneumaticDoorBlock) {
                doorState.handleNeighborChanged(world, doorPos, doorState.getBlock(), pos, false);
            }
        });
    }

    private void updateDoorSide(PneumaticDoorBaseBlockEntity doorBase) {
        doorBase.nonNullLevel().getBlockEntity(doorBase.getBlockPos().relative(doorBase.getRotation()), ModBlockEntityTypes.PNEUMATIC_DOOR.get()).ifPresent(teDoor -> {
            if (doorBase.getRotation().getClockWise() == teDoor.getRotation() && teDoor.rightGoing || doorBase.getRotation().getCounterClockWise() == teDoor.getRotation() && !teDoor.rightGoing) {
                teDoor.rightGoing = !teDoor.rightGoing;
                teDoor.setRotationAngle(0.0f);
                teDoor.setChanged();
            }
        });
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean reversePlacementRotation() {
        return true;
    }

    @Override
    public VoxelShape getUncamouflagedShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        return Shapes.block();
    }

    public int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return blockAccess.getBlockEntity(pos, ModBlockEntityTypes.PNEUMATIC_DOOR_BASE.get()).map(te -> te.shouldPassSignalToDoor() && side == te.getRotation().getOpposite() ? te.getCurrentRedstonePower() : 0).orElse(0);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new PneumaticDoorBaseBlockEntity(pPos, pState);
    }
}

