/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.api.block.PNCBlockStateProperties;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.compressor.FluxCompressorBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FluxCompressorBlock
extends AbstractPneumaticCraftBlock
implements PneumaticCraftEntityBlock {
    private static final VoxelShape SHAPE_N = VoxelShapeUtils.or(Block.box((double)15.0, (double)1.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0), Block.box((double)3.0, (double)15.0, (double)4.0, (double)15.0, (double)16.0, (double)12.0), Block.box((double)2.0, (double)13.0, (double)4.0, (double)3.0, (double)16.0, (double)12.0), Block.box((double)3.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.box((double)0.0, (double)1.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)3.0, (double)3.0, (double)15.0, (double)13.0, (double)13.0, (double)16.0), Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)1.0));
    private static final VoxelShape SHAPE_E = VoxelShapeUtils.rotateY(SHAPE_N, 90);
    private static final VoxelShape SHAPE_S = VoxelShapeUtils.rotateY(SHAPE_E, 90);
    private static final VoxelShape SHAPE_W = VoxelShapeUtils.rotateY(SHAPE_S, 90);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_S, SHAPE_W, SHAPE_N, SHAPE_E};

    public FluxCompressorBlock() {
        super(ModBlocks.defaultProps());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)PNCBlockStateProperties.ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PNCBlockStateProperties.ACTIVE});
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean reversePlacementRotation() {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction d = (Direction)state.getValue((Property)this.directionProperty());
        return SHAPES[d.get2DDataValue()];
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new FluxCompressorBlockEntity(pPos, pState);
    }
}

