/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.Optional;
import me.desht.pneumaticcraft.common.block.AbstractCamouflageBlock;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.elevator.ElevatorBaseBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ElevatorBaseBlock
extends AbstractCamouflageBlock
implements PneumaticCraftEntityBlock {
    private static final VoxelShape BASE = ElevatorBaseBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape TOP = ElevatorBaseBlock.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape CORE = ElevatorBaseBlock.box((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{CORE, TOP});

    public ElevatorBaseBlock() {
        super(ModBlocks.defaultProps().noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AbstractPneumaticCraftBlock.NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)AbstractPneumaticCraftBlock.SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)AbstractPneumaticCraftBlock.WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)AbstractPneumaticCraftBlock.EAST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    public void onPlace(BlockState newState, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(newState, world, pos, oldState, isMoving);
        ElevatorBaseBlock.getCoreBlockEntity(world, pos).ifPresent(ElevatorBaseBlockEntity::updateMaxElevatorHeight);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AbstractPneumaticCraftBlock.NORTH, AbstractPneumaticCraftBlock.SOUTH, AbstractPneumaticCraftBlock.WEST, AbstractPneumaticCraftBlock.EAST});
    }

    @Override
    public VoxelShape getUncamouflagedShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        return super.useItemOn(heldItem, state, level, ElevatorBaseBlock.getCoreElevatorPos(level, pos), player, hand, brtr);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return super.useWithoutItem(state, level, ElevatorBaseBlock.getCoreElevatorPos(level, pos), player, hitResult);
    }

    private static BlockPos getCoreElevatorPos(Level world, BlockPos pos) {
        if (world.getBlockState(pos.relative(Direction.UP)).getBlock() == ModBlocks.ELEVATOR_BASE.get()) {
            return ElevatorBaseBlock.getCoreElevatorPos(world, pos.relative(Direction.UP));
        }
        return pos;
    }

    public static Optional<ElevatorBaseBlockEntity> getCoreBlockEntity(Level level, BlockPos pos) {
        return PneumaticCraftUtils.getBlockEntityAt((BlockGetter)level, pos, ElevatorBaseBlockEntity.class);
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            if (level.getBlockState(pos.relative(Direction.DOWN)).getBlock() == ModBlocks.ELEVATOR_BASE.get()) {
                PneumaticCraftUtils.getBlockEntityAt((BlockGetter)level, pos.below(), ElevatorBaseBlockEntity.class).ifPresent(ElevatorBaseBlockEntity::moveUpgradesFromAbove);
            }
            ElevatorBaseBlock.getCoreBlockEntity(level, pos).ifPresent(ElevatorBaseBlockEntity::updateMaxElevatorHeight);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new ElevatorBaseBlockEntity(pPos, pState);
    }
}

