/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.util;

import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ProgressingLine {
    public final float startX;
    public final float startY;
    public final float startZ;
    public float endX;
    public float endY;
    public float endZ;
    protected float progress = 0.0f;

    public ProgressingLine(Vector3f start, Vector3f end) {
        this.startX = start.x();
        this.startY = start.y();
        this.startZ = start.z();
        this.endX = end.x();
        this.endY = end.y();
        this.endZ = end.z();
    }

    public ProgressingLine(Vec3 start, Vec3 end) {
        this(start.toVector3f(), end.toVector3f());
    }

    public ProgressingLine(float startX, float startY, float startZ, float endX, float endY, float endZ) {
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.endX = endX;
        this.endY = endY;
        this.endZ = endZ;
    }

    public ProgressingLine(float startX, float startY, float endX, float endY) {
        this(new Vector3f(startX, startY, 0.0f), new Vector3f(endX, endY, 0.0f));
    }

    public float getProgress() {
        return this.progress;
    }

    public ProgressingLine setProgress(float progress) {
        this.progress = progress;
        return this;
    }

    public boolean incProgress(float increment) {
        this.progress += increment;
        if (this.progress > 1.0f) {
            this.progress = 1.0f;
            return true;
        }
        if (this.progress < 0.0f) {
            this.progress = 0.0f;
            return true;
        }
        return false;
    }

    public boolean incProgressByDistance(float distance) {
        float totalDistance = (float)Math.sqrt(Math.pow(this.endX - this.startX, 2.0) + Math.pow(this.endY - this.startY, 2.0) + Math.pow(this.endZ - this.startZ, 2.0));
        this.progress += distance / totalDistance;
        if (this.progress > 1.0f) {
            this.progress = 1.0f;
            return true;
        }
        if (this.progress < 0.0f) {
            this.progress = 0.0f;
            return true;
        }
        return false;
    }
}

