/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.DisplayTableBlock;
import me.desht.pneumaticcraft.common.block.entity.utility.DisplayTableBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class DisplayTableRenderer
implements BlockEntityRenderer<DisplayTableBlockEntity> {
    public DisplayTableRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(DisplayTableBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        double d;
        if (!te.nonNullLevel().isLoaded(te.getBlockPos())) {
            return;
        }
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.5, 1.0, 0.5);
        Block b = te.getBlockState().getBlock();
        if (b instanceof DisplayTableBlock.Shelf) {
            DisplayTableBlock.Shelf shelf = (DisplayTableBlock.Shelf)b;
            d = 1.0 - shelf.getTableHeight();
        } else {
            d = 0.0;
        }
        double yOff = d;
        DisplayTableRenderer.renderItemAt(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, te.displayedStack, 0.0, yOff, 0.0, 0.5f, te.getRotation());
        matrixStackIn.popPose();
    }

    static void renderItemAt(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, ItemStack stack, double xOffset, double yOffset, double zOffset, float scale, Direction rot) {
        if (!stack.isEmpty()) {
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.0, -yOffset, 0.0);
            RenderUtils.rotateMatrixForDirection(matrixStackIn, rot);
            if (stack.getItem() instanceof BlockItem) {
                matrixStackIn.translate(xOffset, (double)scale / 4.0, zOffset);
            } else {
                matrixStackIn.translate(xOffset, 0.025, zOffset);
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f));
            }
            matrixStackIn.scale(scale, scale, scale);
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            BakedModel bakedModel = itemRenderer.getModel(stack, (Level)Minecraft.getInstance().level, null, 0);
            itemRenderer.render(stack, ItemDisplayContext.FIXED, true, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, bakedModel);
            matrixStackIn.popPose();
        }
    }
}

