/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.recipe.RefineryRecipe;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTank;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.block.entity.processing.RefineryControllerBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.processing.RefineryOutputBlockEntity;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.inventory.RefineryMenu;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.fluids.FluidStack;

public class RefineryControllerScreen
extends AbstractPneumaticCraftContainerScreen<RefineryMenu, RefineryControllerBlockEntity> {
    private List<RefineryOutputBlockEntity> outputs;
    private WidgetTemperature widgetTemperature;
    private int nExposedFaces;

    public RefineryControllerScreen(RefineryMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.imageHeight = 189;
    }

    @Override
    public void init() {
        super.init();
        this.widgetTemperature = new WidgetTemperature(this.leftPos + 32, this.topPos + 32, TemperatureRange.of(273, 673), 273, 50);
        this.addRenderableWidget((GuiEventListener)this.widgetTemperature);
        this.addRenderableWidget((GuiEventListener)new WidgetTank(this.leftPos + 8, this.topPos + 25, ((RefineryControllerBlockEntity)this.te).getInputTank()));
        int x = this.leftPos + 95;
        int y = this.topPos + 29;
        this.outputs = new ArrayList<RefineryOutputBlockEntity>();
        RefineryOutputBlockEntity te1 = ((RefineryControllerBlockEntity)this.te).findAdjacentOutput();
        if (te1 != null) {
            int i = 0;
            do {
                RefineryOutputBlockEntity teRO = te1;
                if (this.outputs.size() < 4) {
                    this.addRenderableWidget((GuiEventListener)new WidgetTank(x, y, ((RefineryControllerBlockEntity)this.te).outputsSynced[i++]));
                }
                x += 20;
                y -= 4;
                this.outputs.add(teRO);
            } while ((te1 = te1.getLevel().getBlockEntity(te1.getBlockPos().above())) instanceof RefineryOutputBlockEntity);
        }
        if (this.outputs.size() < 2 || this.outputs.size() > 4) {
            this.problemTab.openStat();
        }
        this.nExposedFaces = HeatUtil.countExposedFaces(this.outputs);
    }

    @Override
    public void containerTick() {
        super.containerTick();
        if (((RefineryControllerBlockEntity)this.te).maxTemp > ((RefineryControllerBlockEntity)this.te).minTemp && !((RefineryControllerBlockEntity)this.te).getCurrentRecipeIdSynced().isEmpty()) {
            this.widgetTemperature.setOperatingRange(TemperatureRange.of(((RefineryControllerBlockEntity)this.te).minTemp, ((RefineryControllerBlockEntity)this.te).maxTemp));
        } else {
            this.widgetTemperature.setOperatingRange(null);
        }
        this.widgetTemperature.setTemperature(((RefineryControllerBlockEntity)this.te).getHeatExchanger().getTemperatureAsInt());
        this.widgetTemperature.autoScaleForTemperature();
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float f, int x, int y) {
        super.renderBg(graphics, f, x, y);
        if (this.outputs.size() < 4) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            graphics.fill(this.leftPos + 155, this.topPos + 17, this.leftPos + 171, this.topPos + 81, 0x40FF0000);
            if (this.outputs.size() < 3) {
                graphics.fill(this.leftPos + 135, this.topPos + 21, this.leftPos + 151, this.topPos + 85, 0x40FF0000);
            }
            if (this.outputs.size() < 2) {
                graphics.fill(this.leftPos + 115, this.topPos + 25, this.leftPos + 131, this.topPos + 89, 0x40FF0000);
            }
            if (this.outputs.isEmpty()) {
                graphics.fill(this.leftPos + 95, this.topPos + 29, this.leftPos + 111, this.topPos + 93, 0x40FF0000);
            }
            RenderSystem.disableBlend();
        }
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_REFINERY;
    }

    @Override
    public void addProblems(List<Component> curInfo) {
        super.addProblems(curInfo);
        if (((RefineryControllerBlockEntity)this.te).getHeatExchanger().getTemperatureAsInt() < ((RefineryControllerBlockEntity)this.te).minTemp) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.notEnoughHeat", new Object[0]));
        }
        if (((RefineryControllerBlockEntity)this.te).getInputTank().getFluidAmount() < 10) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.refinery.noOil", new Object[0]));
        }
        if (this.outputs.size() < 2) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.refinery.notEnoughRefineries", new Object[0]));
        } else if (this.outputs.size() > 4) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.refinery.tooManyRefineries", new Object[0]));
        }
    }

    @Override
    protected void addWarnings(List<Component> curInfo) {
        super.addWarnings(curInfo);
        if (((RefineryControllerBlockEntity)this.te).isBlocked()) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.refinery.outputBlocked", new Object[0]));
        }
        if (this.nExposedFaces > 0) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.exposedFaces", this.nExposedFaces, this.outputs.size() * 6));
        }
    }

    @Override
    protected boolean shouldAddUpgradeTab() {
        return false;
    }

    @Override
    public Collection<FluidStack> getTargetFluids() {
        return this.getCurrentRecipe(ModRecipeTypes.REFINERY.get()).map(RecipeHolder::value).map(RefineryRecipe::getOutputs).orElse(Collections.emptyList());
    }
}

