/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.Nullable;

public abstract class ThermoPlantRecipe
extends PneumaticCraftRecipe {
    public abstract boolean matches(FluidStack var1, ItemStack var2);

    public abstract TemperatureRange getOperatingTemperature();

    public abstract float getRequiredPressure();

    public double heatUsed(double ambientTemperature) {
        TemperatureRange range = this.getOperatingTemperature();
        if (range.isAny()) {
            return 0.0;
        }
        double used = (double)range.getMin() > ambientTemperature ? ((double)range.getMin() - ambientTemperature) / 10.0 : ((double)range.getMax() < ambientTemperature ? (ambientTemperature - (double)range.getMax()) / 10.0 : (this.isExothermic() ? ((double)range.getMax() - ambientTemperature) / 10.0 : (ambientTemperature - (double)range.getMin()) / 10.0));
        return this.isExothermic() ? -used : used;
    }

    public int airUsed() {
        return (int)(50.0f * this.getRequiredPressure());
    }

    public abstract Optional<Ingredient> getInputItem();

    public abstract Optional<SizedFluidIngredient> getInputFluid();

    public abstract FluidStack getOutputFluid();

    public abstract ItemStack getOutputItem();

    public abstract float getRecipeSpeed();

    public abstract float getAirUseMultiplier();

    public abstract boolean isExothermic();

    public final int getInputFluidAmount() {
        return this.getInputFluid().map(SizedFluidIngredient::amount).orElse(0);
    }

    public final boolean testFluid(FluidStack fluid) {
        return this.getInputFluid().map(i -> i.ingredient().test(fluid)).orElse(false);
    }

    public final boolean testItem(ItemStack stack) {
        return this.getInputItem().map(i -> i.test(stack)).orElse(false);
    }

    public abstract Inputs inputs();

    public abstract Outputs outputs();

    public record Outputs(FluidStack outputFluid, ItemStack outputItem) {
        public static final Codec<Outputs> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)FluidStack.CODEC.optionalFieldOf("fluid_output", (Object)FluidStack.EMPTY).forGetter(Outputs::outputFluid), (App)ItemStack.CODEC.optionalFieldOf("item_output", (Object)ItemStack.EMPTY).forGetter(Outputs::outputItem)).apply((Applicative)builder, Outputs::new));
        public static StreamCodec<RegistryFriendlyByteBuf, Outputs> STREAM_CODEC = StreamCodec.composite((StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC, Outputs::outputFluid, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, Outputs::outputItem, Outputs::new);
    }

    public record Inputs(Optional<SizedFluidIngredient> inputFluid, Optional<Ingredient> inputItem) {
        public static final Codec<Inputs> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)SizedFluidIngredient.FLAT_CODEC.optionalFieldOf("fluid").forGetter(Inputs::inputFluid), (App)Ingredient.CODEC.optionalFieldOf("item").forGetter(Inputs::inputItem)).apply((Applicative)builder, Inputs::new));
        public static StreamCodec<RegistryFriendlyByteBuf, Inputs> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)SizedFluidIngredient.STREAM_CODEC), Inputs::inputFluid, (StreamCodec)ByteBufCodecs.optional((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC), Inputs::inputItem, Inputs::new);

        public static Inputs of(@Nullable SizedFluidIngredient inputFluid, @Nullable Ingredient inputItem) {
            return new Inputs(Optional.ofNullable(inputFluid), Optional.ofNullable(inputItem));
        }
    }
}

