/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.type;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.ClassTypeInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.RemappedEnumConstant;
import dev.latvian.mods.rhino.util.wrap.TypeWrapperFactory;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EnumTypeInfo
extends ClassTypeInfo
implements TypeWrapperFactory<Object> {
    static final Map<Class<?>, EnumTypeInfo> CACHE = new IdentityHashMap();
    private List<Object> constants;

    public static String getName(Object e) {
        RemappedEnumConstant c;
        String s;
        if (e instanceof RemappedEnumConstant && !(s = (c = (RemappedEnumConstant)e).getRemappedEnumConstantName()).isEmpty()) {
            return s;
        }
        return ((Enum)e).name();
    }

    EnumTypeInfo(Class<?> type) {
        super(type);
    }

    @Override
    public List<Object> enumConstants() {
        if (this.constants == null) {
            this.constants = List.of(this.asClass().getEnumConstants());
        }
        return this.constants;
    }

    @Override
    public Object wrap(Context cx, Object from, TypeInfo target) {
        if (from instanceof CharSequence) {
            String s = from.toString();
            if (s.isEmpty()) {
                return null;
            }
            for (Object entry : this.enumConstants()) {
                if (!EnumTypeInfo.getName(entry).equalsIgnoreCase(s)) continue;
                return entry;
            }
            throw new IllegalArgumentException("'" + s + "' is not a valid enum constant! Valid values are: " + this.enumConstants().stream().map(EnumTypeInfo::getName).map(s1 -> "'" + s1 + "'").collect(Collectors.joining(", ")));
        }
        if (from instanceof Number) {
            int index = ((Number)from).intValue();
            if (index < 0 || index >= this.enumConstants().size()) {
                throw new IllegalArgumentException(index + " is not a valid enum index! Valid values are: 0 - " + (this.enumConstants().size() - 1));
            }
            return this.enumConstants().get(index);
        }
        return from;
    }
}

