/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.CustomFunction;
import dev.latvian.mods.rhino.CustomMember;
import dev.latvian.mods.rhino.CustomProperty;
import dev.latvian.mods.rhino.FieldAndMethods;
import dev.latvian.mods.rhino.Function;
import dev.latvian.mods.rhino.JavaMembers;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.Symbol;
import dev.latvian.mods.rhino.SymbolKey;
import dev.latvian.mods.rhino.SymbolScriptable;
import dev.latvian.mods.rhino.TopLevel;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.DefaultValueTypeHint;
import dev.latvian.mods.rhino.util.Deletable;
import dev.latvian.mods.rhino.util.JavaIteratorWrapper;
import java.util.HashMap;
import java.util.Map;

public class NativeJavaObject
implements Scriptable,
SymbolScriptable,
Wrapper {
    protected Scriptable prototype;
    protected Scriptable parent;
    protected transient Object javaObject;
    protected transient TypeInfo typeInfo;
    protected transient JavaMembers members;
    protected transient Map<String, FieldAndMethods> fieldAndMethods;
    protected transient Map<String, CustomMember> customMembers;
    protected transient boolean isAdapter;

    public NativeJavaObject(Scriptable scope, Object javaObject, TypeInfo typeInfo, Context cx) {
        this(scope, javaObject, typeInfo, false, cx);
    }

    public NativeJavaObject(Scriptable scope, Object javaObject, TypeInfo typeInfo, boolean isAdapter, Context cx) {
        this.parent = scope;
        this.javaObject = javaObject;
        this.typeInfo = typeInfo;
        this.isAdapter = isAdapter;
        this.initMembers(cx, scope);
    }

    protected void initMembers(Context cx, Scriptable scope) {
        Class<?> dynamicType = this.javaObject != null ? this.javaObject.getClass() : this.typeInfo.asClass();
        this.members = JavaMembers.lookupClass(cx, scope, dynamicType, this.typeInfo.asClass(), this.isAdapter);
        this.fieldAndMethods = this.members.getFieldAndMethodsObjects(this, this.javaObject, false, cx);
        this.customMembers = null;
    }

    public void addCustomMember(CustomMember member) {
        if (this.customMembers == null) {
            this.customMembers = new HashMap<String, CustomMember>();
        }
        this.customMembers.put(member.name(), member);
    }

    protected void addCustomFunction(String name, TypeInfo returnType, CustomFunction.Func func, TypeInfo ... argTypes) {
        this.addCustomMember(new CustomMember(name, returnType, new CustomFunction(name, func, argTypes)));
    }

    protected void addCustomFunction(String name, TypeInfo returnType, CustomFunction.NoArgFunc func) {
        this.addCustomFunction(name, returnType, func, TypeInfo.EMPTY_ARRAY);
    }

    public void addCustomProperty(String name, TypeInfo type, CustomProperty getter) {
        this.addCustomMember(new CustomMember(name, type, getter));
    }

    @Override
    public boolean has(Context cx, String name, Scriptable start) {
        return this.members.has(name, false) || this.customMembers != null && this.customMembers.containsKey(name);
    }

    @Override
    public boolean has(Context cx, int index, Scriptable start) {
        return false;
    }

    @Override
    public boolean has(Context cx, Symbol key, Scriptable start) {
        return this.javaObject instanceof Iterable && SymbolKey.ITERATOR.equals(key);
    }

    @Override
    public Object get(Context cx, String name, Scriptable start) {
        CustomMember member;
        FieldAndMethods result;
        if (this.fieldAndMethods != null && (result = this.fieldAndMethods.get(name)) != null) {
            return result;
        }
        if (this.customMembers != null && (member = this.customMembers.get(name)) != null) {
            Object value = member.value();
            if (value instanceof CustomProperty) {
                CustomProperty p = (CustomProperty)value;
                value = p.get(cx);
            }
            return cx.javaToJS(value, start, member.type());
        }
        return this.members.get(this, name, this.javaObject, false, cx);
    }

    @Override
    public Object get(Context cx, Symbol key, Scriptable start) {
        Object object = this.javaObject;
        if (object instanceof Iterable) {
            Iterable itr = (Iterable)object;
            if (SymbolKey.ITERATOR.equals(key)) {
                return new JavaIteratorWrapper(itr.iterator());
            }
        }
        return Scriptable.NOT_FOUND;
    }

    @Override
    public Object get(Context cx, int index, Scriptable start) {
        throw this.members.reportMemberNotFound(Integer.toString(index), cx);
    }

    @Override
    public void put(Context cx, String name, Scriptable start, Object value) {
        if (this.prototype == null || this.members.has(name, false)) {
            this.members.put(this, name, this.javaObject, value, false, cx);
        } else {
            this.prototype.put(cx, name, this.prototype, value);
        }
    }

    @Override
    public void put(Context cx, Symbol symbol, Scriptable start, Object value) {
        String name = symbol.toString();
        if (this.prototype == null || this.members.has(name, false)) {
            this.members.put(this, name, this.javaObject, value, false, cx);
        } else if (this.prototype instanceof SymbolScriptable) {
            ((SymbolScriptable)((Object)this.prototype)).put(cx, symbol, this.prototype, value);
        }
    }

    @Override
    public void put(Context cx, int index, Scriptable start, Object value) {
        throw this.members.reportMemberNotFound(Integer.toString(index), cx);
    }

    @Override
    public boolean hasInstance(Context cx, Scriptable value) {
        return false;
    }

    @Override
    public void delete(Context cx, String name) {
        Object result;
        if (this.fieldAndMethods != null && (result = this.fieldAndMethods.get(name)) != null) {
            Deletable.deleteObject(result);
            return;
        }
        if (this.customMembers != null && (result = this.customMembers.get(name)) != null) {
            Deletable.deleteObject(result);
            return;
        }
        Deletable.deleteObject(this.members.get(this, name, this.javaObject, false, cx));
    }

    @Override
    public void delete(Context cx, Symbol key) {
    }

    @Override
    public void delete(Context cx, int index) {
    }

    @Override
    public Scriptable getPrototype(Context cx) {
        if (this.prototype == null && this.javaObject instanceof String) {
            return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(this.parent), TopLevel.Builtins.String, cx);
        }
        return this.prototype;
    }

    @Override
    public void setPrototype(Scriptable m) {
        this.prototype = m;
    }

    @Override
    public Scriptable getParentScope() {
        return this.parent;
    }

    @Override
    public void setParentScope(Scriptable m) {
        this.parent = m;
    }

    @Override
    public Object[] getIds(Context cx) {
        if (this.customMembers != null) {
            Object[] c = this.customMembers.keySet().toArray(ScriptRuntime.EMPTY_OBJECTS);
            Object[] m = this.members.getIds(false);
            Object[] result = new Object[c.length + m.length];
            System.arraycopy(c, 0, result, 0, c.length);
            System.arraycopy(m, 0, result, c.length, m.length);
            return result;
        }
        return this.members.getIds(false);
    }

    @Override
    public Object unwrap() {
        return this.javaObject;
    }

    @Override
    public String getClassName() {
        return "JavaObject";
    }

    @Override
    public Object getDefaultValue(Context cx, DefaultValueTypeHint hint) {
        Object value;
        if (hint == null) {
            if (this.javaObject instanceof Boolean) {
                hint = DefaultValueTypeHint.BOOLEAN;
            }
            if (this.javaObject instanceof Number) {
                hint = DefaultValueTypeHint.NUMBER;
            }
        }
        if (hint == null || hint == DefaultValueTypeHint.STRING) {
            value = this.javaObject.toString();
        } else {
            String converterName;
            if (hint == DefaultValueTypeHint.BOOLEAN) {
                converterName = "booleanValue";
            } else if (hint == DefaultValueTypeHint.NUMBER) {
                converterName = "doubleValue";
            } else {
                throw Context.reportRuntimeError0("msg.default.value", cx);
            }
            Object converterObject = this.get(cx, converterName, (Scriptable)this);
            if (converterObject instanceof Function) {
                Function f = (Function)converterObject;
                value = f.call(cx, f.getParentScope(), this, ScriptRuntime.EMPTY_OBJECTS);
            } else {
                boolean b;
                value = hint == DefaultValueTypeHint.NUMBER && this.javaObject instanceof Boolean ? ((b = ((Boolean)this.javaObject).booleanValue()) ? (Number)ScriptRuntime.wrapNumber(1.0) : (Number)ScriptRuntime.zeroObj) : this.javaObject.toString();
            }
        }
        return value;
    }
}

