/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.BeanProperty;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.FieldAndMethods;
import dev.latvian.mods.rhino.Kit;
import dev.latvian.mods.rhino.MemberBox;
import dev.latvian.mods.rhino.NativeJavaConstructor;
import dev.latvian.mods.rhino.NativeJavaMethod;
import dev.latvian.mods.rhino.ObjArray;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.ClassVisibilityContext;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.latvian.mods.rhino.util.RemapForJS;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JavaMembers {
    public final Context localContext;
    private final Class<?> cl;
    private final Map<String, Object> members;
    private final Map<String, Object> staticMembers;
    NativeJavaMethod ctors;
    private Map<String, FieldAndMethods> fieldAndMethods;
    private Map<String, FieldAndMethods> staticFieldAndMethods;

    public static String javaSignature(Class<?> type) {
        if (!type.isArray()) {
            return type.getName();
        }
        int arrayDimension = 0;
        do {
            ++arrayDimension;
        } while ((type = type.getComponentType()).isArray());
        String name = type.getName();
        String suffix = "[]";
        if (arrayDimension == 1) {
            return name.concat(suffix);
        }
        int length = name.length() + arrayDimension * suffix.length();
        StringBuilder sb = new StringBuilder(length);
        sb.append(name);
        while (arrayDimension != 0) {
            --arrayDimension;
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static String liveConnectSignature(Class<?>[] argTypes) {
        int N = argTypes.length;
        if (N == 0) {
            return "()";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (int i = 0; i != N; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(JavaMembers.javaSignature(argTypes[i]));
        }
        sb.append(')');
        return sb.toString();
    }

    private static MemberBox findGetter(boolean isStatic, Map<String, Object> ht, String prefix, String propertyName) {
        Object member;
        String getterName = prefix.concat(propertyName);
        if (ht.containsKey(getterName) && (member = ht.get(getterName)) instanceof NativeJavaMethod) {
            NativeJavaMethod njmGet = (NativeJavaMethod)member;
            return JavaMembers.extractGetMethod(njmGet.methods, isStatic);
        }
        return null;
    }

    private static MemberBox extractGetMethod(MemberBox[] methods, boolean isStatic) {
        for (MemberBox method : methods) {
            if (method.argTypes.length != 0 || isStatic && !method.isStatic()) continue;
            Class<?> type = method.getReturnType();
            if (type == Void.TYPE) break;
            return method;
        }
        return null;
    }

    private static MemberBox extractSetMethod(Class<?> type, MemberBox[] methods, boolean isStatic) {
        for (int pass = 1; pass <= 2; ++pass) {
            for (MemberBox method : methods) {
                Class[] params;
                if (isStatic && !method.isStatic() || (params = method.argTypes).length != 1) continue;
                if (pass == 1) {
                    if (params[0] != type) continue;
                    return method;
                }
                if (pass != 2) {
                    Kit.codeBug();
                }
                if (!params[0].isAssignableFrom(type)) continue;
                return method;
            }
        }
        return null;
    }

    private static MemberBox extractSetMethod(MemberBox[] methods, boolean isStatic) {
        for (MemberBox method : methods) {
            if (isStatic && !method.isStatic() || method.getReturnType() != Void.TYPE || method.argTypes.length != 1) continue;
            return method;
        }
        return null;
    }

    public static JavaMembers lookupClass(Context cx, Scriptable scope, Class<?> dynamicType, Class<?> staticType, boolean includeProtected) {
        JavaMembers members;
        Map<Class<?>, JavaMembers> ct = cx.getClassCacheMap();
        Class<?> cl = dynamicType;
        while (true) {
            if ((members = ct.get(cl)) != null) {
                if (cl != dynamicType) {
                    ct.put(dynamicType, members);
                }
                return members;
            }
            try {
                members = new JavaMembers(cl, includeProtected, cx, ScriptableObject.getTopLevelScope(scope));
            }
            catch (SecurityException e) {
                if (staticType != null && staticType.isInterface()) {
                    cl = staticType;
                    staticType = null;
                    continue;
                }
                Class<Object> parent = cl.getSuperclass();
                if (parent == null) {
                    if (cl.isInterface()) {
                        parent = ScriptRuntime.ObjectClass;
                    } else {
                        throw e;
                    }
                }
                cl = parent;
                continue;
            }
            break;
        }
        ct.put(cl, members);
        if (cl != dynamicType) {
            ct.put(dynamicType, members);
        }
        return members;
    }

    JavaMembers(Class<?> cl, boolean includeProtected, Context cx, Scriptable scope) {
        this.localContext = cx;
        if (!cx.visibleToScripts(cl.getName(), ClassVisibilityContext.MEMBER)) {
            throw Context.reportRuntimeError1("msg.access.prohibited", cl.getName(), cx);
        }
        this.members = new HashMap<String, Object>();
        this.staticMembers = new HashMap<String, Object>();
        this.cl = cl;
        this.reflect(scope, includeProtected, cx);
    }

    public boolean has(String name, boolean isStatic) {
        Map<String, Object> ht = isStatic ? this.staticMembers : this.members;
        Object obj = ht.get(name);
        if (obj != null) {
            return true;
        }
        return this.findExplicitFunction(name, isStatic) != null;
    }

    public Object get(Scriptable scope, String name, Object javaObject, boolean isStatic, Context cx) {
        TypeInfo type;
        Object rval;
        Map<String, Object> ht = isStatic ? this.staticMembers : this.members;
        Object member = ht.get(name);
        if (!isStatic && member == null) {
            member = this.staticMembers.get(name);
        }
        if (member == null && (member = this.getExplicitFunction(scope, name, javaObject, isStatic, cx)) == null) {
            return Scriptable.NOT_FOUND;
        }
        if (member instanceof Scriptable) {
            return member;
        }
        try {
            if (member instanceof BeanProperty) {
                BeanProperty bp = (BeanProperty)member;
                if (bp.getter == null) {
                    return Scriptable.NOT_FOUND;
                }
                rval = bp.getter.invoke(javaObject, ScriptRuntime.EMPTY_OBJECTS, cx, scope);
                type = TypeInfo.of(bp.getter.getGenericReturnType());
            } else {
                Field field = (Field)member;
                rval = field.get(isStatic ? null : javaObject);
                type = TypeInfo.of(field.getGenericType());
            }
        }
        catch (Exception ex) {
            throw Context.throwAsScriptRuntimeEx(ex, cx);
        }
        scope = ScriptableObject.getTopLevelScope(scope);
        return cx.wrap(scope, rval, type);
    }

    public void put(Scriptable scope, String name, Object javaObject, Object value, boolean isStatic, Context cx) {
        Map<String, Object> ht = isStatic ? this.staticMembers : this.members;
        Object member = ht.get(name);
        if (!isStatic && member == null) {
            member = this.staticMembers.get(name);
        }
        if (member == null) {
            throw this.reportMemberNotFound(name, cx);
        }
        if (member instanceof FieldAndMethods) {
            FieldAndMethods fam = (FieldAndMethods)ht.get(name);
            member = fam.field;
        }
        if (member instanceof BeanProperty) {
            BeanProperty bp = (BeanProperty)member;
            if (bp.setter == null) {
                throw this.reportMemberNotFound(name, cx);
            }
            if (bp.setters == null || value == null) {
                Object[] args = new Object[]{cx.jsToJava(value, bp.setter.argTypeInfos[0])};
                try {
                    bp.setter.invoke(javaObject, args, cx, scope);
                }
                catch (Exception ex) {
                    throw Context.throwAsScriptRuntimeEx(ex, cx);
                }
            } else {
                Object[] args = new Object[]{value};
                cx.callSync(bp.setters, ScriptableObject.getTopLevelScope(scope), scope, args);
            }
        } else {
            if (!(member instanceof Field)) {
                String str = member == null ? "msg.java.internal.private" : "msg.java.method.assign";
                throw Context.reportRuntimeError1(str, name, cx);
            }
            Field field = (Field)member;
            int fieldModifiers = field.getModifiers();
            if (Modifier.isFinal(fieldModifiers)) {
                throw Context.throwAsScriptRuntimeEx(new IllegalAccessException("Can't modify final field " + field.getName()), cx);
            }
            Object javaValue = cx.jsToJava(value, TypeInfo.of(field.getGenericType()));
            try {
                field.set(javaObject, javaValue);
            }
            catch (IllegalAccessException accessEx) {
                throw Context.throwAsScriptRuntimeEx(accessEx, cx);
            }
            catch (IllegalArgumentException argEx) {
                throw Context.reportRuntimeError3("msg.java.internal.field.type", value.getClass().getName(), field, javaObject.getClass().getName(), cx);
            }
        }
    }

    public Object[] getIds(boolean isStatic) {
        Map<String, Object> map = isStatic ? this.staticMembers : this.members;
        return map.keySet().toArray(ScriptRuntime.EMPTY_OBJECTS);
    }

    private MemberBox findExplicitFunction(String name, boolean isStatic) {
        boolean isCtor;
        int sigStart = name.indexOf(40);
        if (sigStart < 0) {
            return null;
        }
        Map<String, Object> ht = isStatic ? this.staticMembers : this.members;
        MemberBox[] methodsOrCtors = null;
        boolean bl = isCtor = isStatic && sigStart == 0;
        if (isCtor) {
            methodsOrCtors = this.ctors.methods;
        } else {
            String trueName = name.substring(0, sigStart);
            Object obj = ht.get(trueName);
            if (!isStatic && obj == null) {
                obj = this.staticMembers.get(trueName);
            }
            if (obj instanceof NativeJavaMethod) {
                NativeJavaMethod njm = (NativeJavaMethod)obj;
                methodsOrCtors = njm.methods;
            }
        }
        if (methodsOrCtors != null) {
            for (MemberBox methodsOrCtor : methodsOrCtors) {
                Class[] type = methodsOrCtor.argTypes;
                String sig = JavaMembers.liveConnectSignature(type);
                if (sigStart + sig.length() != name.length() || !name.regionMatches(sigStart, sig, 0, sig.length())) continue;
                return methodsOrCtor;
            }
        }
        return null;
    }

    private Object getExplicitFunction(Scriptable scope, String name, Object javaObject, boolean isStatic, Context cx) {
        Map<String, Object> ht = isStatic ? this.staticMembers : this.members;
        Object member = null;
        MemberBox methodOrCtor = this.findExplicitFunction(name, isStatic);
        if (methodOrCtor != null) {
            Scriptable prototype = ScriptableObject.getFunctionPrototype(scope, cx);
            if (methodOrCtor.isCtor()) {
                NativeJavaConstructor fun = new NativeJavaConstructor(methodOrCtor);
                fun.setPrototype(prototype);
                member = fun;
                ht.put(name, fun);
            } else {
                String trueName = methodOrCtor.getName();
                member = ht.get(trueName);
                if (member instanceof NativeJavaMethod && ((NativeJavaMethod)member).methods.length > 1) {
                    NativeJavaMethod fun = new NativeJavaMethod(methodOrCtor, name);
                    fun.setPrototype(prototype);
                    ht.put(name, fun);
                    member = fun;
                }
            }
        }
        return member;
    }

    private void reflect(Scriptable scope, boolean includeProtected, Context cx) {
        Map<String, Object> ht;
        if (this.cl.isAnnotationPresent(HideFromJS.class)) {
            this.ctors = new NativeJavaMethod(new MemberBox[0], this.cl.getSimpleName());
            return;
        }
        for (MethodInfo methodInfo : this.getAccessibleMethods(cx, includeProtected)) {
            ObjArray overloadedMethods;
            String name;
            Method method = methodInfo.method;
            int mods = method.getModifiers();
            boolean isStatic = Modifier.isStatic(mods);
            Map<String, Object> ht2 = isStatic ? this.staticMembers : this.members;
            Object value = ht2.get(name = methodInfo.name);
            if (value == null) {
                ht2.put(name, method);
                continue;
            }
            if (value instanceof ObjArray) {
                overloadedMethods = (ObjArray)value;
            } else {
                if (!(value instanceof Method)) {
                    Kit.codeBug();
                }
                overloadedMethods = new ObjArray();
                overloadedMethods.add(value);
                ht2.put(name, overloadedMethods);
            }
            overloadedMethods.add(method);
        }
        for (int tableCursor = 0; tableCursor != 2; ++tableCursor) {
            boolean isStatic = tableCursor == 0;
            ht = isStatic ? this.staticMembers : this.members;
            for (Map.Entry<String, Object> entry : ht.entrySet()) {
                MemberBox[] methodBoxes;
                Object value = entry.getValue();
                if (value instanceof Method) {
                    methodBoxes = new MemberBox[]{new MemberBox((Method)value)};
                } else {
                    ObjArray overloadedMethods = (ObjArray)value;
                    int N = overloadedMethods.size();
                    if (N < 2) {
                        Kit.codeBug();
                    }
                    methodBoxes = new MemberBox[N];
                    for (int i = 0; i != N; ++i) {
                        Method method = (Method)overloadedMethods.get(i);
                        methodBoxes[i] = new MemberBox(method);
                    }
                }
                NativeJavaMethod fun = new NativeJavaMethod(methodBoxes);
                if (scope != null) {
                    ScriptRuntime.setFunctionProtoAndParent(cx, scope, fun);
                }
                ht.put(entry.getKey(), fun);
            }
        }
        for (FieldInfo fieldInfo : this.getAccessibleFields(cx, includeProtected)) {
            Field field = fieldInfo.field;
            String name = fieldInfo.name;
            int mods = field.getModifiers();
            try {
                boolean isStatic = Modifier.isStatic(mods);
                Map<String, Object> ht3 = isStatic ? this.staticMembers : this.members;
                Object member = ht3.get(name);
                if (member == null) {
                    ht3.put(name, field);
                    continue;
                }
                if (member instanceof NativeJavaMethod) {
                    Map<String, FieldAndMethods> fmht;
                    NativeJavaMethod method = (NativeJavaMethod)member;
                    FieldAndMethods fam = new FieldAndMethods(scope, method.methods, field, cx);
                    Map<String, FieldAndMethods> map = fmht = isStatic ? this.staticFieldAndMethods : this.fieldAndMethods;
                    if (fmht == null) {
                        fmht = new HashMap<String, FieldAndMethods>();
                        if (isStatic) {
                            this.staticFieldAndMethods = fmht;
                        } else {
                            this.fieldAndMethods = fmht;
                        }
                    }
                    fmht.put(name, fam);
                    ht3.put(name, fam);
                    continue;
                }
                if (member instanceof Field) {
                    Field oldField = (Field)member;
                    if (!oldField.getDeclaringClass().isAssignableFrom(field.getDeclaringClass())) continue;
                    ht3.put(name, field);
                    continue;
                }
                Kit.codeBug();
            }
            catch (SecurityException e) {
                Context.reportWarning("Could not access field " + name + " of class " + this.cl.getName() + " due to lack of privileges.", cx);
            }
        }
        for (int tableCursor = 0; tableCursor != 2; ++tableCursor) {
            boolean isStatic = tableCursor == 0;
            ht = isStatic ? this.staticMembers : this.members;
            HashMap<Object, BeanProperty> toAdd = new HashMap<Object, BeanProperty>();
            for (String name : ht.keySet()) {
                Object member;
                Object v;
                String nameComponent;
                boolean memberIsGetMethod = name.startsWith("get");
                boolean memberIsSetMethod = name.startsWith("set");
                boolean memberIsIsMethod = name.startsWith("is");
                if (!memberIsGetMethod && !memberIsIsMethod && !memberIsSetMethod || (nameComponent = name.substring(memberIsIsMethod ? 2 : 3)).length() == 0) continue;
                Object beanPropertyName = nameComponent;
                char ch0 = nameComponent.charAt(0);
                if (Character.isUpperCase(ch0)) {
                    if (nameComponent.length() == 1) {
                        beanPropertyName = nameComponent.toLowerCase();
                    } else {
                        char ch1 = nameComponent.charAt(1);
                        if (!Character.isUpperCase(ch1)) {
                            beanPropertyName = Character.toLowerCase(ch0) + nameComponent.substring(1);
                        }
                    }
                }
                if (toAdd.containsKey(beanPropertyName) || (v = ht.get(beanPropertyName)) != null) continue;
                MemberBox getter = JavaMembers.findGetter(isStatic, ht, "get", nameComponent);
                if (getter == null) {
                    getter = JavaMembers.findGetter(isStatic, ht, "is", nameComponent);
                }
                MemberBox setter = null;
                NativeJavaMethod setters = null;
                String setterName = "set".concat(nameComponent);
                if (ht.containsKey(setterName) && (member = ht.get(setterName)) instanceof NativeJavaMethod) {
                    NativeJavaMethod njmSet = (NativeJavaMethod)member;
                    if (getter != null) {
                        Class<?> type = getter.getReturnType();
                        setter = JavaMembers.extractSetMethod(type, njmSet.methods, isStatic);
                    } else {
                        setter = JavaMembers.extractSetMethod(njmSet.methods, isStatic);
                    }
                    if (njmSet.methods.length > 1) {
                        setters = njmSet;
                    }
                }
                BeanProperty bp = new BeanProperty(getter, setter, setters);
                toAdd.put(beanPropertyName, bp);
            }
            ht.putAll(toAdd);
        }
        List<Constructor<?>> constructors = this.getAccessibleConstructors();
        MemberBox[] ctorMembers = new MemberBox[constructors.size()];
        for (int i = 0; i != constructors.size(); ++i) {
            ctorMembers[i] = new MemberBox(constructors.get(i));
        }
        this.ctors = new NativeJavaMethod(ctorMembers, this.cl.getSimpleName());
    }

    public List<Constructor<?>> getAccessibleConstructors() {
        ArrayList constructorsList = new ArrayList();
        for (Constructor<?> c : this.cl.getConstructors()) {
            if (c.isAnnotationPresent(HideFromJS.class) || !Modifier.isPublic(c.getModifiers())) continue;
            constructorsList.add(c);
        }
        return constructorsList;
    }

    public Collection<FieldInfo> getAccessibleFields(Context cx, boolean includeProtected) {
        LinkedHashMap<String, FieldInfo> fieldMap = new LinkedHashMap<String, FieldInfo>();
        try {
            for (Class<?> currentClass = this.cl; currentClass != null; currentClass = currentClass.getSuperclass()) {
                HashSet<String> remapPrefixes = new HashSet<String>();
                for (RemapPrefixForJS r : (RemapPrefixForJS[])currentClass.getAnnotationsByType(RemapPrefixForJS.class)) {
                    String s = r.value().trim();
                    if (s.isEmpty()) continue;
                    remapPrefixes.add(s);
                }
                for (Field field : JavaMembers.getDeclaredFieldsSafe(currentClass)) {
                    int mods = field.getModifiers();
                    if (Modifier.isTransient(mods) || !Modifier.isPublic(mods) && (!includeProtected || !Modifier.isProtected(mods)) || field.isAnnotationPresent(HideFromJS.class)) continue;
                    try {
                        if (includeProtected && Modifier.isProtected(mods) && !field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        FieldInfo info = new FieldInfo(field);
                        RemapForJS remap = field.getAnnotation(RemapForJS.class);
                        if (remap != null) {
                            info.name = remap.value().trim();
                        }
                        if (info.name.isEmpty()) {
                            for (String s : remapPrefixes) {
                                if (!field.getName().startsWith(s)) continue;
                                info.name = field.getName().substring(s.length()).trim();
                                break;
                            }
                        }
                        if (info.name.isEmpty()) {
                            info.name = cx.getMappedField(currentClass, field);
                        }
                        if (info.name.isEmpty()) {
                            info.name = field.getName();
                        }
                        if (fieldMap.containsKey(info.name)) continue;
                        fieldMap.put(info.name, info);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return fieldMap.values();
    }

    public Collection<MethodInfo> getAccessibleMethods(Context cx, boolean includeProtected) {
        LinkedHashMap<MethodSignature, MethodInfo> methodMap = new LinkedHashMap<MethodSignature, MethodInfo>();
        ArrayDeque stack = new ArrayDeque();
        stack.add(this.cl);
        while (!stack.isEmpty()) {
            Class currentClass = (Class)stack.pop();
            HashSet<String> remapPrefixes = new HashSet<String>();
            for (RemapPrefixForJS r : (RemapPrefixForJS[])currentClass.getAnnotationsByType(RemapPrefixForJS.class)) {
                String s = r.value().trim();
                if (s.isEmpty()) continue;
                remapPrefixes.add(s);
            }
            for (Method method : JavaMembers.getDeclaredMethodsSafe(currentClass)) {
                int mods = method.getModifiers();
                if (!Modifier.isPublic(mods) && (!includeProtected || !Modifier.isProtected(mods))) continue;
                MethodSignature signature = new MethodSignature(method);
                MethodInfo info = (MethodInfo)methodMap.get(signature);
                boolean hidden = method.isAnnotationPresent(HideFromJS.class);
                if (info == null) {
                    try {
                        if (!hidden && includeProtected && Modifier.isProtected(mods) && !method.isAccessible()) {
                            method.setAccessible(true);
                        }
                        info = new MethodInfo(method);
                        methodMap.put(signature, info);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (info == null) continue;
                if (hidden) {
                    info.hidden = true;
                    continue;
                }
                RemapForJS remap = method.getAnnotation(RemapForJS.class);
                if (remap != null) {
                    info.name = remap.value().trim();
                }
                if (info.name.isEmpty()) {
                    for (String s : remapPrefixes) {
                        if (!method.getName().startsWith(s)) continue;
                        info.name = method.getName().substring(s.length()).trim();
                        break;
                    }
                }
                if (!info.name.isEmpty()) continue;
                info.name = cx.getMappedMethod(currentClass, method);
            }
            stack.addAll(Arrays.asList(currentClass.getInterfaces()));
            Class parent = currentClass.getSuperclass();
            if (parent == null) continue;
            stack.add(parent);
        }
        ArrayList<MethodInfo> list = new ArrayList<MethodInfo>(methodMap.size());
        for (MethodInfo m : methodMap.values()) {
            if (m.hidden) continue;
            if (m.name.isEmpty()) {
                m.name = m.method.getName();
            }
            list.add(m);
        }
        return list;
    }

    private static Method[] getDeclaredMethodsSafe(Class<?> cl) {
        try {
            return cl.getDeclaredMethods();
        }
        catch (Throwable t) {
            System.err.println("[Rhino] Failed to get declared methods for " + cl.getName() + ": " + String.valueOf(t));
            return new Method[0];
        }
    }

    private static Field[] getDeclaredFieldsSafe(Class<?> cl) {
        try {
            return cl.getDeclaredFields();
        }
        catch (Throwable t) {
            System.err.println("[Rhino] Failed to get declared fields for " + cl.getName() + ": " + String.valueOf(t));
            return new Field[0];
        }
    }

    public Map<String, FieldAndMethods> getFieldAndMethodsObjects(Scriptable scope, Object javaObject, boolean isStatic, Context cx) {
        Map<String, FieldAndMethods> ht;
        Map<String, FieldAndMethods> map = ht = isStatic ? this.staticFieldAndMethods : this.fieldAndMethods;
        if (ht == null) {
            return null;
        }
        int len = ht.size();
        HashMap<String, FieldAndMethods> result = new HashMap<String, FieldAndMethods>(len);
        for (FieldAndMethods fam : ht.values()) {
            FieldAndMethods famNew = new FieldAndMethods(scope, fam.methods, fam.field, cx);
            famNew.javaObject = javaObject;
            result.put(fam.field.getName(), famNew);
        }
        return result;
    }

    RuntimeException reportMemberNotFound(String memberName, Context cx) {
        return Context.reportRuntimeError2("msg.java.member.not.found", this.cl.getName(), memberName, cx);
    }

    public static class MethodInfo {
        public Method method;
        public String name = "";
        public boolean hidden = false;

        public MethodInfo(Method m) {
            this.method = m;
        }
    }

    public static class FieldInfo {
        public final Field field;
        public String name = "";

        public FieldInfo(Field f) {
            this.field = f;
        }
    }

    public record MethodSignature(String name, Class<?>[] args) {
        private static final Class<?>[] NO_ARGS = new Class[0];

        public MethodSignature(Method method) {
            this(method.getName(), method.getParameterCount() == 0 ? NO_ARGS : method.getParameterTypes());
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof MethodSignature) {
                MethodSignature ms = (MethodSignature)o;
                return ms.name.equals(this.name) && Arrays.equals(this.args, ms.args);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.name.hashCode() ^ this.args.length;
        }
    }
}

