/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Callable;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.EqualObjectGraphs;
import dev.latvian.mods.rhino.Function;
import dev.latvian.mods.rhino.NativeObject;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;

public class BoundFunction
extends BaseFunction {
    private final Callable targetFunction;
    private final Scriptable boundThis;
    private final Object[] boundArgs;
    private final int length;

    private static Object[] concat(Object[] first, Object[] second) {
        Object[] args = new Object[first.length + second.length];
        System.arraycopy(first, 0, args, 0, first.length);
        System.arraycopy(second, 0, args, first.length, second.length);
        return args;
    }

    static boolean equalObjectGraphs(Context cx, BoundFunction f1, BoundFunction f2, EqualObjectGraphs eq) {
        return eq.equalGraphs(cx, f1.boundThis, f2.boundThis) && eq.equalGraphs(cx, f1.targetFunction, f2.targetFunction) && eq.equalGraphs(cx, f1.boundArgs, f2.boundArgs);
    }

    public BoundFunction(Context cx, Scriptable scope, Callable targetFunction, Scriptable boundThis, Object[] boundArgs) {
        this.targetFunction = targetFunction;
        this.boundThis = boundThis;
        this.boundArgs = boundArgs;
        this.length = targetFunction instanceof BaseFunction ? Math.max(0, ((BaseFunction)targetFunction).getLength() - boundArgs.length) : 0;
        ScriptRuntime.setFunctionProtoAndParent(cx, scope, this);
        BaseFunction thrower = ScriptRuntime.typeErrorThrower(cx);
        NativeObject throwing = new NativeObject(cx.factory);
        throwing.put(cx, "get", (Scriptable)throwing, (Object)thrower);
        throwing.put(cx, "set", (Scriptable)throwing, (Object)thrower);
        throwing.put(cx, "enumerable", (Scriptable)throwing, (Object)Boolean.FALSE);
        throwing.put(cx, "configurable", (Scriptable)throwing, (Object)Boolean.FALSE);
        throwing.preventExtensions();
        this.defineOwnProperty(cx, "caller", throwing, false);
        this.defineOwnProperty(cx, "arguments", throwing, false);
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] extraArgs) {
        Scriptable callThis = this.boundThis != null ? this.boundThis : cx.getTopCallOrThrow();
        return this.targetFunction.call(cx, scope, callThis, BoundFunction.concat(this.boundArgs, extraArgs));
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] extraArgs) {
        if (this.targetFunction instanceof Function) {
            return ((Function)this.targetFunction).construct(cx, scope, BoundFunction.concat(this.boundArgs, extraArgs));
        }
        throw ScriptRuntime.typeError0(cx, "msg.not.ctor");
    }

    @Override
    public boolean hasInstance(Context cx, Scriptable instance) {
        if (this.targetFunction instanceof Function) {
            return ((Function)this.targetFunction).hasInstance(cx, instance);
        }
        throw ScriptRuntime.typeError0(cx, "msg.not.ctor");
    }

    @Override
    public int getLength() {
        return this.length;
    }
}

