/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.plugin.rei.display;

import java.util.ArrayList;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.mehvahdjukaar.jeed.common.EffectInfo;
import net.mehvahdjukaar.jeed.plugin.rei.REIPlugin;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class EffectInfoDisplay
extends EffectInfo
implements Display {
    private final List<EntryIngredient> inputEntries;
    private final List<List<EntryStack<?>>> slots;
    private final List<EntryIngredient> outputEntries;

    protected EffectInfoDisplay(MobEffectInstance effectInstance, Component description) {
        super(effectInstance, List.of(description));
        MobEffect effect = (MobEffect)effectInstance.getEffect().value();
        List<ItemStack> providers = EffectInfoDisplay.computeEffectProviders(effect);
        List<Ingredient> ingredientsList = EffectInfoDisplay.groupIngredients(providers);
        ArrayList<EntryIngredient> allInputs = new ArrayList<EntryIngredient>(ingredientsList.stream().map(EntryIngredients::ofIngredient).toList());
        this.outputEntries = List.of(EntryIngredient.of((EntryStack)EntryStack.of(REIPlugin.EFFECT_ENTRY_TYPE, (Object)effectInstance).normalize()));
        allInputs.addAll(this.outputEntries);
        allInputs.addAll(EffectInfoDisplay.computeEffectToEffectProviders(effect).stream().map(e -> EntryStack.of(REIPlugin.EFFECT_ENTRY_TYPE, (Object)effectInstance).normalize()).map(EntryIngredient::of).toList());
        this.inputEntries = allInputs.stream().toList();
        this.slots = EffectInfoDisplay.divideIntoSlots(providers, EntryIngredients::ofItemStacks);
    }

    public List<List<EntryStack<?>>> getSlots() {
        return this.slots;
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputEntries;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.outputEntries;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return REIPlugin.EFFECTS_INFO_CATEGORY;
    }

    public static EffectInfoDisplay create(Holder<MobEffect> effect) {
        Component text = EffectInfoDisplay.getDescription(effect);
        return new EffectInfoDisplay(new MobEffectInstance(effect), text);
    }
}

