/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.plugin.rei;

import dev.architectury.event.CompoundEventResult;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPluginClient;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.api.IEffectScreenExtension;
import net.mehvahdjukaar.jeed.common.IPlugin;
import net.mehvahdjukaar.jeed.common.ScreenExtensionsHandler;
import net.mehvahdjukaar.jeed.plugin.rei.display.EffectInfoDisplay;
import net.mehvahdjukaar.jeed.plugin.rei.display.EffectInfoDisplayCategory;
import net.mehvahdjukaar.jeed.plugin.rei.ingredient.EffectInstanceDefinition;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

@REIPluginClient
public class REIPlugin
implements REIClientPlugin,
IPlugin {
    public static final CategoryIdentifier<EffectInfoDisplay> EFFECTS_INFO_CATEGORY = CategoryIdentifier.of((ResourceLocation)Jeed.res("effects"));
    public static final EntryType<MobEffectInstance> EFFECT_ENTRY_TYPE = EntryType.deferred((ResourceLocation)ResourceLocation.tryParse((String)"effect"));

    public REIPlugin() {
        Jeed.PLUGIN = this;
    }

    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new EffectInfoDisplayCategory());
        registry.addWorkstations(EFFECTS_INFO_CATEGORY, new EntryStack[]{EntryStacks.of((ItemLike)Items.POTION)});
    }

    public void registerDisplays(DisplayRegistry registry) {
        for (Holder.Reference<MobEffect> e : Jeed.getEffectList()) {
            registry.add((Display)EffectInfoDisplay.create(e));
        }
    }

    public void registerEntryTypes(EntryTypeRegistry registry) {
        registry.register(EFFECT_ENTRY_TYPE, (EntryDefinition)new EffectInstanceDefinition());
        registry.registerBridge(EFFECT_ENTRY_TYPE, VanillaEntryTypes.ITEM, input -> {
            ItemStack item = (ItemStack)input.cheatsAs().getValue();
            return CompoundEventResult.interruptTrue(Stream.of(EntryStacks.of((ItemStack)item)));
        });
    }

    public void registerEntries(EntryRegistry registry) {
        for (Holder.Reference<MobEffect> e : Jeed.getEffectList()) {
            registry.addEntry(EntryStack.of(EFFECT_ENTRY_TYPE, (Object)new MobEffectInstance(e)));
        }
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerFocusedStack((screen, mouse) -> {
            if (screen instanceof AbstractContainerScreen) {
                AbstractContainerScreen as = (AbstractContainerScreen)screen;
                return REIPlugin.typed(mouse, as);
            }
            return CompoundEventResult.pass();
        });
    }

    private static <T extends AbstractContainerScreen<?>> CompoundEventResult<EntryStack<?>> typed(Point mouse, T as) {
        MobEffectInstance e;
        Object ext = ScreenExtensionsHandler.getExtension(as);
        if (ext != null && (e = ext.getEffectAtPosition(as, mouse.x, mouse.y, IEffectScreenExtension.CallReason.RECIPE_KEY)) != null) {
            return CompoundEventResult.interruptTrue((Object)EntryStack.of(EFFECT_ENTRY_TYPE, (Object)e));
        }
        return CompoundEventResult.pass();
    }

    @Override
    public void onClickedEffect(MobEffectInstance effect, double x, double y, int button) {
        ViewSearchBuilder.builder().addRecipesFor(EntryStack.of(EFFECT_ENTRY_TYPE, (Object)effect).normalize()).open();
    }
}

