/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.plugin.jei.display;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.recipe.RecipeType;
import net.mehvahdjukaar.jeed.common.Constants;
import net.mehvahdjukaar.jeed.common.EffectInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class EffectInfoRecipe
extends EffectInfo {
    public static final RecipeType<EffectInfoRecipe> TYPE = RecipeType.create((String)"jeed", (String)"effect_info", EffectInfoRecipe.class);
    protected final List<Ingredient> ingredients;
    protected final List<Ingredient> slots;

    protected EffectInfoRecipe(MobEffectInstance effectInstance, List<Ingredient> ingredients, List<FormattedText> description) {
        super(effectInstance, description);
        this.ingredients = ingredients;
        this.slots = EffectInfoRecipe.divideIntoSlots(ingredients, EffectInfo::mergeIngredients);
    }

    public static List<EffectInfoRecipe> create(Holder<MobEffect> effect) {
        Minecraft minecraft = Minecraft.getInstance();
        Component text = EffectInfoRecipe.getDescription(effect);
        List<Ingredient> inputs = EffectInfoRecipe.groupIngredients(EffectInfoRecipe.computeEffectProviders((MobEffect)effect.value()));
        int listH = EffectInfoRecipe.getListHeight(inputs);
        ArrayList<EffectInfoRecipe> recipes = new ArrayList<EffectInfoRecipe>();
        List<FormattedText> descriptionLines = EffectInfoRecipe.expandNewlines(text);
        descriptionLines = EffectInfoRecipe.wrapDescriptionLines(descriptionLines);
        int lineCount = descriptionLines.size();
        Objects.requireNonNull(minecraft.font);
        int maxLinesPerPage = (Constants.RECIPE_HEIGHT - 35 - listH) / (9 + Constants.LINE_SPACING);
        int pageCount = EffectInfoRecipe.divideCeil(lineCount, maxLinesPerPage);
        for (int i = 0; i < pageCount; ++i) {
            int startLine = i * maxLinesPerPage;
            int endLine = Math.min((i + 1) * maxLinesPerPage, lineCount);
            List<FormattedText> description = descriptionLines.subList(startLine, endLine);
            EffectInfoRecipe recipe = new EffectInfoRecipe(new MobEffectInstance(effect), inputs, description);
            recipes.add(recipe);
        }
        return recipes;
    }

    private static int divideCeil(int numerator, int denominator) {
        return (int)Math.ceil((float)numerator / (float)denominator);
    }

    private static List<FormattedText> expandNewlines(Component descriptionComponents) {
        ArrayList<FormattedText> descriptionLinesExpanded = new ArrayList<FormattedText>();
        ExpandNewLineTextAcceptor newLineTextAcceptor = new ExpandNewLineTextAcceptor();
        descriptionComponents.visit((FormattedText.StyledContentConsumer)newLineTextAcceptor, Style.EMPTY);
        newLineTextAcceptor.addLinesTo(descriptionLinesExpanded);
        return descriptionLinesExpanded;
    }

    private static List<FormattedText> wrapDescriptionLines(List<FormattedText> descriptionLines) {
        Minecraft minecraft = Minecraft.getInstance();
        ArrayList<FormattedText> descriptionLinesWrapped = new ArrayList<FormattedText>();
        for (FormattedText descriptionLine : descriptionLines) {
            List textLines = minecraft.font.getSplitter().splitLines(descriptionLine, Constants.RECIPE_WIDTH, Style.EMPTY);
            descriptionLinesWrapped.addAll(textLines);
        }
        return descriptionLinesWrapped;
    }

    private static class ExpandNewLineTextAcceptor
    implements FormattedText.StyledContentConsumer<Void> {
        private final List<FormattedText> lines = new ArrayList<FormattedText>();
        @Nullable
        private MutableComponent lastComponent;

        private ExpandNewLineTextAcceptor() {
        }

        public Optional<Void> accept(Style style, String line) {
            String[] descriptionLineExpanded = line.split("\\\\n");
            for (int i = 0; i < descriptionLineExpanded.length; ++i) {
                String s = descriptionLineExpanded[i];
                if (s.isEmpty()) {
                    if (i == 0 && this.lastComponent != null) {
                        this.lines.add((FormattedText)this.lastComponent);
                        this.lastComponent = null;
                        continue;
                    }
                    this.lines.add(Component.EMPTY);
                    continue;
                }
                MutableComponent textComponent = Component.literal((String)s);
                textComponent.setStyle(style);
                if (this.lastComponent != null) {
                    if (i == 0) {
                        if (!this.lastComponent.getStyle().isEmpty() && !this.lastComponent.getStyle().equals((Object)style)) {
                            this.lastComponent = Component.literal((String)"").append((Component)this.lastComponent);
                        }
                        this.lastComponent.append((Component)textComponent);
                        continue;
                    }
                    this.lines.add((FormattedText)this.lastComponent);
                    this.lastComponent = null;
                }
                if (i == descriptionLineExpanded.length - 1) {
                    this.lastComponent = textComponent;
                    continue;
                }
                this.lines.add((FormattedText)textComponent);
            }
            return Optional.empty();
        }

        public void addLinesTo(List<FormattedText> descriptionLinesExpanded) {
            descriptionLinesExpanded.addAll(this.lines);
            if (this.lastComponent != null) {
                descriptionLinesExpanded.add((FormattedText)this.lastComponent);
            }
        }
    }
}

