/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.recipe.pigment;

import java.util.Map;
import java.util.Objects;
import ky.someone.mods.gag.GAGRegistry;
import ky.someone.mods.gag.item.PigmentJarItem;
import ky.someone.mods.gag.item.data.Pigment;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class PigmentJarLeatherDyingRecipe
extends CustomRecipe {
    private static final Map<Item, Integer> VALID_ITEMS = Map.of(Items.LEATHER_HELMET, 5, Items.LEATHER_CHESTPLATE, 8, Items.LEATHER_LEGGINGS, 7, Items.LEATHER_BOOTS, 4, Items.LEATHER_HORSE_ARMOR, 7);

    public PigmentJarLeatherDyingRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput container, Level level) {
        ItemStack leatherItem = ItemStack.EMPTY;
        boolean hasPigment = false;
        int pigmentAmount = 0;
        for (ItemStack stack : container.items()) {
            Item item = stack.getItem();
            if (VALID_ITEMS.containsKey(item)) {
                if (!leatherItem.isEmpty()) {
                    return false;
                }
                leatherItem = stack;
                continue;
            }
            if (stack.is((Item)GAGRegistry.PIGMENT_JAR.get())) {
                hasPigment = true;
                pigmentAmount += PigmentJarItem.getColorAmount(stack);
                continue;
            }
            if (item instanceof DyeItem) {
                pigmentAmount += 4;
                continue;
            }
            if (stack.isEmpty()) continue;
            return false;
        }
        return !leatherItem.isEmpty() && hasPigment && pigmentAmount >= VALID_ITEMS.get(leatherItem.getItem());
    }

    public ItemStack assemble(CraftingInput container, HolderLookup.Provider reg) {
        ItemStack leatherItem = ItemStack.EMPTY;
        boolean showsInTooltip = true;
        Pigment output = Pigment.EMPTY;
        for (ItemStack stack : container.items()) {
            Pigment pigment;
            Item item = stack.getItem();
            if (VALID_ITEMS.containsKey(item)) {
                if (!leatherItem.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                leatherItem = stack.copy();
                if (!stack.has(DataComponents.DYED_COLOR)) continue;
                DyedItemColor color = Objects.requireNonNull((DyedItemColor)stack.get(DataComponents.DYED_COLOR));
                showsInTooltip = color.showInTooltip();
                Pigment leatherPigment = Pigment.ofRgb(color.rgb(), VALID_ITEMS.get(item));
                output = output.mix(leatherPigment);
                continue;
            }
            if (stack.is((Item)GAGRegistry.PIGMENT_JAR.get())) {
                pigment = PigmentJarItem.getPigment(stack);
                output = output.mix(pigment);
                continue;
            }
            pigment = stack.getItem();
            if (!(pigment instanceof DyeItem)) continue;
            DyeItem dye = (DyeItem)pigment;
            Pigment dyePigment = Pigment.forLeather(dye.getDyeColor());
            output = output.mix(dyePigment);
        }
        if (leatherItem.isEmpty() || output.isEmpty()) {
            return ItemStack.EMPTY;
        }
        leatherItem.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(output.rgb(), showsInTooltip));
        return leatherItem;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput container) {
        NonNullList remaining = NonNullList.withSize((int)container.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stack = container.getItem(i);
            if (!PigmentJarItem.isNonEmptyJar(stack)) continue;
            remaining.set(i, (Object)((Item)GAGRegistry.PIGMENT_JAR.get()).getDefaultInstance());
        }
        return remaining;
    }

    public boolean canCraftInDimensions(int i, int j) {
        return i * j >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)GAGRegistry.PIGMENT_JAR_MIXING.get();
    }
}

