/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.item;

import dev.shadowsoffire.placebo.color.GradientColor;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import ky.someone.mods.gag.GAGRegistry;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.config.GAGConfig;
import ky.someone.mods.gag.entity.TimeAcceleratorEntity;
import ky.someone.mods.gag.item.GAGItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TemporalPouchItem
extends GAGItem {
    public static final TagKey<BlockEntityType<?>> DO_NOT_ACCELERATE = TagKey.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (ResourceLocation)GAGUtil.id("do_not_accelerate"));

    public TemporalPouchItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public static int getStoredGrains(ItemStack stack) {
        return (Integer)stack.getOrDefault(GAGRegistry.GRAINS_OF_TIME_DATA, (Object)0);
    }

    public static void setStoredGrains(ItemStack stack, int time) {
        int newStoredTime = Math.min(time, GAGConfig.temporalPouch.capacity());
        stack.set(GAGRegistry.GRAINS_OF_TIME_DATA, (Object)newStoredTime);
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
    }

    public MutableComponent getTimeForDisplay(ItemStack stack) {
        int storedGrains = TemporalPouchItem.getStoredGrains(stack);
        int seconds = storedGrains * GAGConfig.temporalPouch.durationPerUse() / GAGConfig.temporalPouch.grainsUsed();
        int minutes = seconds / 60;
        int hours = seconds / 3600;
        String timeString = String.format("%ds", seconds);
        if (hours > 0) {
            timeString = String.format("%dh %dm %ds", hours, minutes % 60, seconds % 60);
        } else if (minutes > 0) {
            timeString = String.format("%dm %ds", minutes, seconds % 60);
        }
        return Component.translatable((String)"item.gag.time_sand_pouch.info.stored_grains", (Object[])new Object[]{storedGrains, timeString});
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        int storedGrains;
        Player player;
        super.inventoryTick(stack, level, entity, itemSlot, isSelected);
        if (level.isClientSide || !(entity instanceof Player) || (player = (Player)entity).isFakePlayer()) {
            return;
        }
        if (level.getGameTime() % 20L == 0L && (storedGrains = TemporalPouchItem.getStoredGrains(stack)) + 20 < GAGConfig.temporalPouch.capacity()) {
            TemporalPouchItem.setStoredGrains(stack, storedGrains + 20);
        }
        if (level.getGameTime() % 200L == 0L && TemporalPouchItem.getStoredGrains(stack) != 0) {
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                ItemStack invStack = player.getInventory().getItem(i);
                if (invStack.getItem() != this || invStack == stack) continue;
                int otherTimeData = TemporalPouchItem.getStoredGrains(invStack);
                int myTimeData = TemporalPouchItem.getStoredGrains(stack);
                if (myTimeData < otherTimeData) {
                    TemporalPouchItem.setStoredGrains(stack, 0);
                    continue;
                }
                TemporalPouchItem.setStoredGrains(invStack, 0);
            }
        }
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        if (level.isClientSide) {
            return InteractionResult.PASS;
        }
        BlockPos pos = ctx.getClickedPos();
        ItemStack stack = ctx.getItemInHand();
        Player player = ctx.getPlayer();
        Registry beRegistry = level.registryAccess().registryOrThrow(Registries.BLOCK_ENTITY_TYPE);
        boolean validBlockEntity = Optional.ofNullable(level.getBlockEntity(pos)).map(BlockEntity::getType).flatMap(arg_0 -> ((Registry)beRegistry).getResourceKey(arg_0)).flatMap(arg_0 -> ((Registry)beRegistry).getHolder(arg_0)).filter(type -> !type.is(DO_NOT_ACCELERATE)).isPresent();
        boolean randomTickingState = level.getBlockState(pos).isRandomlyTicking();
        if (!(GAGConfig.temporalPouch.isLevelAllowed(level) && (validBlockEntity || GAGConfig.temporalPouch.allowRandomTicks() && randomTickingState))) {
            return InteractionResult.FAIL;
        }
        int baseDuration = 20 * GAGConfig.temporalPouch.durationPerUse();
        TimeAcceleratorEntity accelerator = level.getEntitiesOfClass(TimeAcceleratorEntity.class, new AABB(pos)).stream().findFirst().orElse(null);
        if (accelerator == null) {
            if (this.shouldDamage(player, stack) && TemporalPouchItem.getStoredGrains(stack) < this.grainsRequired(1)) {
                return InteractionResult.SUCCESS;
            }
            accelerator = Objects.requireNonNull((TimeAcceleratorEntity)GAGRegistry.TIME_ACCELERATOR.get().create(level));
            accelerator.setPos(Vec3.atCenterOf((Vec3i)pos));
            accelerator.setTicksRemaining(baseDuration);
            level.addFreshEntity((Entity)accelerator);
        }
        int clicks = accelerator.getTimesAccelerated();
        if (clicks++ >= GAGConfig.temporalPouch.maxRate() || this.shouldDamage(player, stack) && TemporalPouchItem.getStoredGrains(stack) < this.grainsRequired(clicks)) {
            return InteractionResult.SUCCESS;
        }
        accelerator.setTimesAccelerated(clicks);
        accelerator.setTicksRemaining((accelerator.getTicksRemaining() + baseDuration) / 2);
        if (this.shouldDamage(player, stack)) {
            TemporalPouchItem.setStoredGrains(stack, TemporalPouchItem.getStoredGrains(stack) - this.grainsRequired(clicks));
        }
        this.playNote(level, pos, clicks);
        return InteractionResult.SUCCESS;
    }

    public int grainsRequired(int level) {
        return (1 << Math.max(0, level - 1)) * GAGConfig.temporalPouch.grainsUsed();
    }

    private void playNote(Level level, BlockPos pos, int rate) {
        int[] pitches = new int[]{-6, -4, -2, -1, 1, 3, 5, 6};
        float pitch = (float)Math.pow(2.0, (double)pitches[(rate - 1) % 8] / 12.0);
        Holder.Reference sound = rate > 8 ? SoundEvents.NOTE_BLOCK_FLUTE : SoundEvents.NOTE_BLOCK_CHIME;
        level.playSound(null, pos, (SoundEvent)sound.value(), SoundSource.PLAYERS, 3.0f, pitch);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.literal((String)"If I could save time in a ").append((Component)Component.literal((String)"bottle").withStyle(ChatFormatting.STRIKETHROUGH)).append((Component)Component.literal((String)" bundle...")).withStyle(GAGUtil.TOOLTIP_FLAVOUR).withStyle(ChatFormatting.ITALIC));
        GAGUtil.appendInfoTooltip(tooltip, List.of(Component.translatable((String)"item.gag.time_sand_pouch.info.1").withStyle(GAGUtil.TOOLTIP_MAIN), Component.translatable((String)"item.gag.time_sand_pouch.info.2").withStyle(GAGUtil.TOOLTIP_MAIN)));
        tooltip.add((Component)this.getTimeForDisplay(stack).withStyle(style -> style.withColor((TextColor)GradientColor.RAINBOW)));
    }

    @Override
    public boolean shouldBob(ItemStack oldStack, ItemStack newStack) {
        return false;
    }
}

