/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag;

import dev.shadowsoffire.placebo.registry.DeferredHelper;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.block.NoSolicitorsSign;
import ky.someone.mods.gag.effect.RepellingEffect;
import ky.someone.mods.gag.entity.FishingDynamiteEntity;
import ky.someone.mods.gag.entity.MiningDynamiteEntity;
import ky.someone.mods.gag.entity.TimeAcceleratorEntity;
import ky.someone.mods.gag.item.DynamiteItem;
import ky.someone.mods.gag.item.EnergizedHearthstoneItem;
import ky.someone.mods.gag.item.EscapeRopeItem;
import ky.someone.mods.gag.item.HearthstoneItem;
import ky.someone.mods.gag.item.ItemWithSubsets;
import ky.someone.mods.gag.item.LabelingToolItem;
import ky.someone.mods.gag.item.PigmentJarItem;
import ky.someone.mods.gag.item.RepellingItem;
import ky.someone.mods.gag.item.TemporalPouchItem;
import ky.someone.mods.gag.item.data.Pigment;
import ky.someone.mods.gag.item.data.TeleportPos;
import ky.someone.mods.gag.menu.LabelingMenu;
import ky.someone.mods.gag.recipe.pigment.PigmentJarFromDyeRecipe;
import ky.someone.mods.gag.recipe.pigment.PigmentJarLeatherDyingRecipe;
import ky.someone.mods.gag.recipe.pigment.PigmentJarMixingRecipe;
import ky.someone.mods.gag.recipe.pigment.PigmentJarSplittingRecipe;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.RegisterEvent;

public interface GAGRegistry {
    public static final DeferredHelper HELPER = DeferredHelper.create((String)"gag");
    public static final DeferredItem<Item> HEARTHSTONE = HELPER.item("hearthstone", () -> new HearthstoneItem());
    public static final DeferredHolder<CreativeModeTab, ?> CREATIVE_TAB = HELPER.creativeTab("gag", builder -> builder.icon(() -> ((Item)HEARTHSTONE.get()).getDefaultInstance()).title((Component)Component.literal((String)"Gadgets against Grind")).displayItems((params, output) -> GAGRegistry.getItems().mapMulti((item, sink) -> {
        sink.accept(item.getDefaultInstance());
        if (item instanceof ItemWithSubsets) {
            ItemWithSubsets subsets = (ItemWithSubsets)item;
            for (ItemStack subItem : subsets.getAdditionalSubItems()) {
                sink.accept(subItem);
            }
        }
    }).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0))));
    public static final BlockAndItem<NoSolicitorsSign, ?> NO_SOLICITORS_SIGN = BlockAndItem.create("no_solicitors", NoSolicitorsSign::new);
    public static final DeferredItem<TemporalPouchItem> TIME_SAND_POUCH = HELPER.item("time_sand_pouch", TemporalPouchItem::new);
    public static final DeferredItem<Item> ESCAPE_ROPE = HELPER.item("escape_rope", EscapeRopeItem::new);
    public static final DeferredItem<Item> ENERGIZED_HEARTHSTONE = HELPER.item("energized_hearthstone", EnergizedHearthstoneItem::new);
    public static final DeferredItem<Item> SACRED_SALT = GAGRegistry.repelling("sacred_salt", p -> p.stacksTo(16).rarity(Rarity.UNCOMMON), 800, 1, false);
    public static final DeferredItem<Item> SACRED_SALVE = GAGRegistry.repelling("sacred_salve", p -> p.stacksTo(4).rarity(Rarity.RARE), 2400, 2, true);
    public static final DeferredItem<Item> SACRED_BALM = GAGRegistry.repelling("sacred_balm", p -> p.stacksTo(4).rarity(Rarity.RARE), 7200, 0, true);
    public static final DeferredItem<Item> MINING_DYNAMITE_ITEM = GAGRegistry.dynamite("mining_dynamite", MiningDynamiteEntity::new, List.of(Component.translatable((String)"item.gag.mining_dynamite.info").withStyle(GAGUtil.TOOLTIP_MAIN)), 1.5);
    public static final DeferredItem<Item> FISHING_DYNAMITE_ITEM = GAGRegistry.dynamite("fishing_dynamite", FishingDynamiteEntity::new, List.of(Component.translatable((String)"item.gag.fishing_dynamite.info").withStyle(GAGUtil.TOOLTIP_MAIN)), 1.5);
    public static final DeferredItem<Item> LABELING_TOOL = HELPER.item("labeling_tool", LabelingToolItem::new);
    public static final DeferredItem<Item> PIGMENT_JAR = HELPER.item("pigment_jar", PigmentJarItem::new);
    public static final DataComponentType<Pigment> PIGMENT_DATA = HELPER.component("pigment", builder -> builder.persistent(Pigment.CODEC).networkSynchronized(Pigment.STREAM_CODEC));
    public static final DataComponentType<Integer> GRAINS_OF_TIME_DATA = HELPER.component("grains_of_time", builder -> builder.persistent(ExtraCodecs.POSITIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<TeleportPos> TELEPORT_TARGET_DATA = HELPER.component("teleport_target", builder -> builder.persistent(TeleportPos.CODEC).networkSynchronized(TeleportPos.STREAM_CODEC));
    public static final Supplier<EntityType<TimeAcceleratorEntity>> TIME_ACCELERATOR = HELPER.entity("time_accelerator", TimeAcceleratorEntity::new, MobCategory.MISC, builder -> builder.sized(0.1f, 0.1f).noSummon());
    public static final Supplier<EntityType<MiningDynamiteEntity>> MINING_DYNAMITE = HELPER.entity("mining_dynamite", MiningDynamiteEntity::new, MobCategory.MISC, builder -> builder.sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10));
    public static final Supplier<EntityType<FishingDynamiteEntity>> FISHING_DYNAMITE = HELPER.entity("fishing_dynamite", FishingDynamiteEntity::new, MobCategory.MISC, builder -> builder.sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10));
    public static final Supplier<SoundEvent> DYNAMITE_THROW = GAGRegistry.simpleSound("entity.dynamite.throw");
    public static final Supplier<SoundEvent> HEARTHSTONE_THUNDER = GAGRegistry.simpleSound("item.hearthstone.thunder");
    public static final Supplier<SoundEvent> REPELLING_APPLY = GAGRegistry.simpleSound("item.repelling.apply");
    public static final Supplier<SoundEvent> TELEPORT = GAGRegistry.simpleSound("generic.teleport");
    public static final Supplier<SoundEvent> TELEPORT_FAIL = GAGRegistry.simpleSound("generic.teleport.fail");
    public static final DeferredHolder<RecipeSerializer<?>, ?> PIGMENT_JAR_MIXING = GAGRegistry.specialRecipe("pigment_jar_mixing", PigmentJarMixingRecipe::new);
    public static final DeferredHolder<RecipeSerializer<?>, ?> PIGMENT_JAR_FROM_DYE = GAGRegistry.specialRecipe("pigment_jar_from_dye", PigmentJarFromDyeRecipe::new);
    public static final DeferredHolder<RecipeSerializer<?>, ?> PIGMENT_JAR_SPLITTING = GAGRegistry.specialRecipe("pigment_jar_splitting", PigmentJarSplittingRecipe::new);
    public static final DeferredHolder<RecipeSerializer<?>, ?> PIGMENT_JAR_LEATHER_DYING = GAGRegistry.specialRecipe("pigment_jar_leather_dying", PigmentJarLeatherDyingRecipe::new);
    public static final MenuType<LabelingMenu> LABELING_MENU = HELPER.menu("labeling", LabelingMenu::new);
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> MAGIC_PARTICLE = HELPER.simpleParticle("magic", true);
    public static final DeferredHolder<MobEffect, RepellingEffect> REPELLING = HELPER.effect("repelling", RepellingEffect::new);

    @SubscribeEvent
    public static void register(RegisterEvent event) {
        HELPER.register(event);
    }

    public static DeferredItem<Item> repelling(String name, UnaryOperator<Item.Properties> properties, int duration, int amplifier, boolean hasTooltip) {
        return HELPER.item(name, () -> new RepellingItem((Item.Properties)properties.apply(new Item.Properties()), duration, amplifier, hasTooltip));
    }

    public static DeferredItem<Item> dynamite(String name, DynamiteItem.EntityFactory factory, List<Component> tooltip, double throwSpeed) {
        return HELPER.item(name, () -> new DynamiteItem(new Item.Properties(), factory, tooltip, throwSpeed));
    }

    public static Supplier<SoundEvent> simpleSound(String name) {
        return HELPER.sound(name, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)GAGUtil.id(name)));
    }

    public static DeferredHolder<RecipeSerializer<?>, ?> specialRecipe(String name, SimpleCraftingRecipeSerializer.Factory<?> factory) {
        return HELPER.recipeSerializer(name, () -> new SimpleCraftingRecipeSerializer(factory));
    }

    public static Stream<Item> getItems() {
        return HELPER.getRegisteredObjects(Registries.ITEM).stream().map(Holder::value);
    }

    public record BlockAndItem<B extends Block, I extends Item>(DeferredBlock<B> block, DeferredItem<I> item) implements Supplier<B>,
    ItemLike
    {
        public static <B extends Block> BlockAndItem<B, BlockItem> create(String name, Supplier<B> supplier) {
            DeferredBlock block = HELPER.block(name, supplier);
            DeferredItem item = HELPER.blockItem(name, (Holder)block);
            return new BlockAndItem(block, item);
        }

        @Override
        public B get() {
            return (B)((Block)this.block.get());
        }

        public Item asItem() {
            return this.item.asItem();
        }
    }
}

