/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag;

import com.mojang.logging.LogUtils;
import ky.someone.mods.gag.GAGRegistry;
import ky.someone.mods.gag.block.NoSolicitorsSign;
import ky.someone.mods.gag.client.GAGClient;
import ky.someone.mods.gag.config.GAGConfig;
import ky.someone.mods.gag.effect.RepellingEffect;
import ky.someone.mods.gag.item.EnergizedHearthstoneItem;
import ky.someone.mods.gag.network.GAGConfigPhase;
import ky.someone.mods.gag.network.GAGNetwork;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityStruckByLightningEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import org.slf4j.Logger;

@Mod(value="gag")
@EventBusSubscriber
public class GAG {
    public static final Logger LOGGER = LogUtils.getLogger();

    public GAG(IEventBus bus) {
        bus.register(GAGRegistry.class);
        bus.register(GAGNetwork.class);
        bus.register(GAGConfigPhase.class);
        bus.addListener(FMLCommonSetupEvent.class, event -> GAGConfig.load());
        if (FMLEnvironment.dist == Dist.CLIENT) {
            GAGClient.init(bus);
        }
    }

    @SubscribeEvent
    public static void checkSpawn(FinalizeSpawnEvent event) {
        if (RepellingEffect.applyRepel((LivingEntity)event.getEntity(), (LevelAccessor)event.getLevel(), event.getX(), event.getY(), event.getZ())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void entityLightning(EntityStruckByLightningEvent event) {
        if (EnergizedHearthstoneItem.lightningStrike(event.getLightning(), event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        ServerLevel level;
        Level level2;
        Entity entity = event.getEntity();
        EntityType type = entity.getType();
        if ((type == EntityType.WANDERING_TRADER || type == EntityType.TRADER_LLAMA) && (level2 = event.getLevel()) instanceof ServerLevel && NoSolicitorsSign.blockWandererSpawn(level = (ServerLevel)level2, entity.getOnPos())) {
            event.setCanceled(true);
        }
    }
}

