/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.showcaseitem.network;

import com.ultramega.showcaseitem.ShowcaseItemFeature;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ShareItemData(int slot, int containerId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ShareItemData> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"showcaseitem", (String)"share_item_data"));
    public static final StreamCodec<ByteBuf, ShareItemData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ShareItemData::slot, (StreamCodec)ByteBufCodecs.INT, ShareItemData::containerId, ShareItemData::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ShowcaseItemFeature.shareItem(serverPlayer, this.slot, this.containerId);
            }
        }).exceptionally(e -> null);
    }
}

