/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;

abstract class CustomParticle
extends SingleQuadParticle {
    protected CustomParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
    }

    protected CustomParticle(ClientLevel level, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(level, x, y, z, motionX, motionY, motionZ);
    }

    abstract ResourceLocation getTexture();

    public void render(VertexConsumer buffer, Camera entityIn, float partialTicks) {
        TextureManager textureManager = Minecraft.getInstance().getTextureManager();
        RenderSystem.depthMask((boolean)false);
        textureManager.bindForSetup(this.getTexture());
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(GameRenderer::getParticleShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getTexture());
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        super.render(buffer, entityIn, partialTicks);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }

    protected float getU0() {
        return 0.0f;
    }

    protected float getU1() {
        return 1.0f;
    }

    protected float getV0() {
        return 0.0f;
    }

    protected float getV1() {
        return 1.0f;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }
}

