/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.item;

import com.lothrazar.simpletomb.ConfigTomb;
import com.lothrazar.simpletomb.TombRegistry;
import com.lothrazar.simpletomb.block.BlockTomb;
import com.lothrazar.simpletomb.data.DeathHelper;
import com.lothrazar.simpletomb.data.MessageType;
import com.lothrazar.simpletomb.helper.NBTHelper;
import com.lothrazar.simpletomb.helper.WorldHelper;
import com.lothrazar.simpletomb.proxy.ClientUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class GraveKeyItem
extends SwordItem {
    public GraveKeyItem(Item.Properties properties) {
        super((Tier)Tiers.STONE, properties.stacksTo(1).attributes(SwordItem.createAttributes((Tier)Tiers.STONE, (int)3, (float)-2.4f)));
    }

    public Component getDescription() {
        return Component.translatable((String)this.getDescriptionId()).withStyle(ChatFormatting.GOLD);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int count) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            GlobalPos location = this.getTombPos(stack);
            if (location == null || !location.equals((Object)DeathHelper.ORIGIN) || !location.equals((Object)level.dimension())) {
                return;
            }
            BlockPos tombPos = location.pos();
            double distance = this.getDistance(tombPos, player.blockPosition());
            boolean canTp = false;
            if (player.isCreative()) {
                canTp = (Boolean)ConfigTomb.TPCREATIVE.get();
            } else {
                boolean bl = canTp = (Integer)ConfigTomb.TPSURVIVAL.get() > 0 && distance < (double)((Integer)ConfigTomb.TPSURVIVAL.get()).intValue() || (Integer)ConfigTomb.TPSURVIVAL.get() == -1;
            }
            if (canTp) {
                if (count <= 1) {
                    player.teleportTo((double)tombPos.getX(), (double)tombPos.getY(), (double)tombPos.getZ());
                } else if (level.isClientSide) {
                    ClientUtils.produceParticleCasting(entity, p -> !p.isUsingItem());
                }
            }
        }
    }

    private double getDistance(BlockPos pos, BlockPos pos2) {
        double deltX = pos.getX() - pos2.getX();
        double deltY = pos.getY() - pos2.getY();
        double deltZ = pos.getZ() - pos2.getZ();
        return Math.sqrt(deltX * deltX + deltY * deltY + deltZ * deltZ);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 86;
    }

    public InteractionResult useOn(UseOnContext context) {
        if (((Boolean)ConfigTomb.KEYOPENONUSE.get()).booleanValue()) {
            BlockState state;
            BlockPos pos = context.getClickedPos();
            Player player = context.getPlayer();
            if (player.getItemInHand(context.getHand()).getItem() == TombRegistry.GRAVE_KEY.get() && (state = context.getLevel().getBlockState(pos)).getBlock() instanceof BlockTomb) {
                BlockTomb.activatePlayerGrave(context.getLevel(), pos, state, player);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        playerIn.startUsingItem(handIn);
        return InteractionResultHolder.success((Object)itemstack);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag tooltipFlag) {
        Level level = context.level();
        if (level != null && level.isClientSide && Screen.hasShiftDown()) {
            GlobalPos location = this.getTombPos(stack);
            BlockPos pos = ClientUtils.getPlayerPos();
            if (pos != null && !location.equals((Object)DeathHelper.ORIGIN)) {
                BlockPos tombPos = location.pos();
                int distance = (int)this.getDistance(tombPos, pos);
                list.add((Component)Component.translatable((String)MessageType.MESSAGE_DISTANCE.getKey(), (Object[])new Object[]{distance, tombPos.getX(), tombPos.getY(), tombPos.getZ(), WorldHelper.getDimensionName((ResourceKey<Level>)location.dimension())}).withStyle(ChatFormatting.DARK_PURPLE));
            }
        }
        super.appendHoverText(stack, context, list, tooltipFlag);
    }

    public boolean setTombPos(ItemStack stack, GlobalPos location) {
        if (stack.getItem() == this && !location.equals((Object)DeathHelper.ORIGIN)) {
            NBTHelper.setLocation(stack, location);
            return true;
        }
        return false;
    }

    public GlobalPos getTombPos(ItemStack stack) {
        return stack.getItem() == this ? NBTHelper.getLocation(stack) : DeathHelper.ORIGIN;
    }

    public boolean removeKeyForGraveInInventory(Player player, GlobalPos graveLoc) {
        IItemHandler itemHandler = (IItemHandler)player.getCapability(Capabilities.ItemHandler.ENTITY, null);
        if (itemHandler != null) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (stack.getItem() != TombRegistry.GRAVE_KEY.get() || !((GraveKeyItem)((Object)TombRegistry.GRAVE_KEY.get())).getTombPos(stack).equals((Object)graveLoc)) continue;
                itemHandler.extractItem(i, 1, false);
                return true;
            }
        }
        return false;
    }

    public int countKeyInInventory(Player player) {
        return (int)player.getInventory().items.stream().filter(stack -> stack.getItem() == TombRegistry.GRAVE_KEY.get()).count();
    }
}

