/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.event;

import com.lothrazar.simpletomb.ModTomb;
import com.lothrazar.simpletomb.TombRegistry;
import com.lothrazar.simpletomb.block.BlockEntityTomb;
import com.lothrazar.simpletomb.data.PlayerTombRecords;
import com.lothrazar.simpletomb.data.TombCommands;
import com.lothrazar.simpletomb.event.PlayerTombEvents;
import com.lothrazar.simpletomb.helper.WorldHelper;
import com.lothrazar.simpletomb.item.GraveKeyItem;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class CommandEvents {
    private static final String ARG_SELECTED = "selected";
    private static final String ARG_PLAYER = "player";

    @SubscribeEvent
    public void onRegisterCommandsEvent(RegisterCommandsEvent event) {
        CommandDispatcher r = event.getDispatcher();
        r.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"simpletomb").requires(p -> p.hasPermission(3))).then(Commands.literal((String)TombCommands.RESTORE.toString()).then(Commands.argument((String)ARG_PLAYER, (ArgumentType)GameProfileArgument.gameProfile()).suggests((cs, b) -> this.buildPlayerArg((CommandContext<CommandSourceStack>)cs, b)).then(Commands.argument((String)ARG_SELECTED, (ArgumentType)IntegerArgumentType.integer()).executes(x -> this.exeRestore((CommandContext<CommandSourceStack>)x, this.getPlayerProfile((CommandContext<CommandSourceStack>)x), IntegerArgumentType.getInteger((CommandContext)x, (String)ARG_SELECTED))))))).then(Commands.literal((String)TombCommands.KEY.toString()).then(Commands.argument((String)ARG_PLAYER, (ArgumentType)GameProfileArgument.gameProfile()).suggests((cs, b) -> this.buildPlayerArg((CommandContext<CommandSourceStack>)cs, b)).then(Commands.argument((String)ARG_SELECTED, (ArgumentType)IntegerArgumentType.integer()).executes(x -> this.exeKey((CommandContext<CommandSourceStack>)x, this.getPlayerProfile((CommandContext<CommandSourceStack>)x), IntegerArgumentType.getInteger((CommandContext)x, (String)ARG_SELECTED))))))).then(Commands.literal((String)TombCommands.LIST.toString()).then(Commands.argument((String)ARG_PLAYER, (ArgumentType)GameProfileArgument.gameProfile()).suggests((cs, b) -> this.buildPlayerArg((CommandContext<CommandSourceStack>)cs, b)).executes(x -> this.exeList((CommandContext<CommandSourceStack>)x, this.getPlayerProfile((CommandContext<CommandSourceStack>)x)))))).then(Commands.literal((String)TombCommands.DELETE.toString()).then(Commands.argument((String)ARG_PLAYER, (ArgumentType)GameProfileArgument.gameProfile()).suggests((cs, b) -> this.buildPlayerArg((CommandContext<CommandSourceStack>)cs, b)).executes(x -> this.exeDelete((CommandContext<CommandSourceStack>)x, this.getPlayerProfile((CommandContext<CommandSourceStack>)x))))));
    }

    private CompletableFuture<Suggestions> buildPlayerArg(CommandContext<CommandSourceStack> cs, SuggestionsBuilder b) {
        return SharedSuggestionProvider.suggest(((CommandSourceStack)cs.getSource()).getServer().getPlayerList().getPlayers().stream().map(p -> p.getGameProfile().getName()), (SuggestionsBuilder)b);
    }

    private GameProfile getPlayerProfile(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return GameProfileArgument.getGameProfiles(ctx, (String)ARG_PLAYER).stream().findFirst().orElse(null);
    }

    private int exeDelete(CommandContext<CommandSourceStack> ctx, GameProfile target) throws CommandSyntaxException {
        PlayerTombRecords found = ModTomb.GLOBAL.findGrave(target.getId());
        if (found != null) {
            int previous = found.playerGraves.size();
            found.deleteAll();
            MutableComponent msg = Component.translatable((String)("Deleted: " + previous));
            msg.setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> msg, false);
        }
        return 0;
    }

    private int exeList(CommandContext<CommandSourceStack> ctx, GameProfile target) throws CommandSyntaxException {
        PlayerTombRecords found = ModTomb.GLOBAL.findGrave(target.getId());
        if (found != null && found.playerGraves.size() > 0) {
            for (int i = 0; i < found.playerGraves.size(); ++i) {
                MutableComponent msg = Component.translatable((String)found.toDisplayString(i, (HolderLookup.Provider)((CommandSourceStack)ctx.getSource()).registryAccess()));
                msg.setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD));
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> msg, false);
            }
        } else {
            MutableComponent msg = Component.literal((String)"Found: #0");
            msg.setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> msg, false);
        }
        return 0;
    }

    private int exeKey(CommandContext<CommandSourceStack> ctx, GameProfile target, int index) throws CommandSyntaxException {
        PlayerTombRecords found = ModTomb.GLOBAL.findGrave(target.getId());
        if (found != null) {
            CompoundTag grave = found.playerGraves.get(index);
            if (grave == null) {
                ModTomb.LOGGER.error("Invalid grave index {}; try between 0 and  {}", (Object)index, (Object)(found.playerGraves.size() - 1));
                return 1;
            }
            GlobalPos spawnPos = new GlobalPos(PlayerTombRecords.getDim(grave), PlayerTombRecords.getPos(grave));
            ItemStack key = new ItemStack((ItemLike)TombRegistry.GRAVE_KEY.get());
            ((GraveKeyItem)((Object)TombRegistry.GRAVE_KEY.get())).setTombPos(key, spawnPos);
            PlayerTombEvents.putKeyName(target.getName(), key);
            MutableComponent msg = Component.translatable((String)("Attempting to give the key for tomb [" + index + "] to player " + target.getName() + ":" + String.valueOf(target.getId())));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> msg, false);
            ServerPlayer user = ((CommandSourceStack)ctx.getSource()).getServer().getPlayerList().getPlayer(target.getId());
            ItemHandlerHelper.giveItemToPlayer((Player)user, (ItemStack)key);
        }
        return 0;
    }

    private int exeRestore(CommandContext<CommandSourceStack> ctx, GameProfile target, int index) throws CommandSyntaxException {
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)("Attempting to restore tomb [" + index + "] for player " + target.getName() + ":" + String.valueOf(target.getId()))), false);
        PlayerTombRecords found = ModTomb.GLOBAL.findGrave(target.getId());
        if (found != null) {
            BlockState state;
            CompoundTag grave = found.playerGraves.get(index);
            if (grave == null) {
                ModTomb.LOGGER.error("Invalid grave index {}; try between 0 and  {}", (Object)index, (Object)(found.playerGraves.size() - 1));
                return 1;
            }
            BlockPos pos = PlayerTombRecords.getPos(grave);
            ResourceKey<Level> dim = PlayerTombRecords.getDim(grave);
            List<ItemStack> drops = PlayerTombRecords.getDrops(grave, (HolderLookup.Provider)((CommandSourceStack)ctx.getSource()).registryAccess());
            ServerLevel targetWorld = ((CommandSourceStack)ctx.getSource()).getLevel().getServer().getLevel(dim);
            boolean wasPlaced = WorldHelper.placeGrave((Level)targetWorld, pos, state = PlayerTombEvents.getRandomGrave(targetWorld, Direction.NORTH));
            if (wasPlaced) {
                BlockEntityTomb tile = (BlockEntityTomb)targetWorld.getBlockEntity(pos);
                tile.initTombstoneOwner(target);
                IItemHandler itemHandler = (IItemHandler)targetWorld.getCapability(Capabilities.ItemHandler.BLOCK, pos, null);
                for (ItemStack d : drops) {
                    ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)d.copy(), (boolean)false);
                }
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Restored tomb with at [" + String.valueOf(pos) + "] in " + String.valueOf(dim))), false);
        }
        return 0;
    }
}

