/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.data;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PlayerTombRecords {
    UUID playerId;
    public List<CompoundTag> playerGraves = new ArrayList<CompoundTag>();

    public PlayerTombRecords(UUID id, CompoundTag first) {
        this.playerId = id;
        this.playerGraves.add(first);
    }

    public PlayerTombRecords() {
    }

    public CompoundTag getGrave(int index) {
        if (index >= this.playerGraves.size()) {
            return null;
        }
        return this.playerGraves.get(index);
    }

    public void read(CompoundTag data, UUID playerId) {
        this.playerId = playerId;
        if (data.contains("simpletomb")) {
            ListTag glist = data.getList("simpletomb", 10);
            for (int i = 0; i < glist.size(); ++i) {
                this.playerGraves.add(glist.getCompound(i));
            }
        }
    }

    public CompoundTag write() {
        CompoundTag data = new CompoundTag();
        ListTag glist = new ListTag();
        glist.addAll(this.playerGraves);
        data.put("simpletomb", (Tag)glist);
        return data;
    }

    public static BlockPos getPos(CompoundTag grave) {
        return (BlockPos)NbtUtils.readBlockPos((CompoundTag)grave, (String)"pos").get();
    }

    public static ResourceKey<Level> getDim(CompoundTag grave) {
        ResourceLocation dim = ResourceLocation.parse((String)grave.getString("dim"));
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dim);
    }

    public static List<ItemStack> getDrops(CompoundTag grave, HolderLookup.Provider provider) {
        ListTag drops = grave.getList("drops", 10);
        ArrayList<ItemStack> done = new ArrayList<ItemStack>();
        for (int i = 0; i < drops.size(); ++i) {
            done.add(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)drops.getCompound(i)));
        }
        return done;
    }

    public void deleteAll() {
        this.playerGraves = new ArrayList<CompoundTag>();
    }

    public String toDisplayString(int i, HolderLookup.Provider provider) {
        CompoundTag gd = this.getGrave(i);
        return String.format("[%d] (%s) (%s) {%d}", i, PlayerTombRecords.getDim(gd), PlayerTombRecords.getPos(gd).toShortString(), PlayerTombRecords.getDrops(gd, provider).size());
    }
}

