/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.block;

import com.lothrazar.simpletomb.TombRegistry;
import com.lothrazar.simpletomb.block.BlockEntityTomb;
import com.lothrazar.simpletomb.block.ModelTomb;
import com.lothrazar.simpletomb.data.DeathHelper;
import com.lothrazar.simpletomb.data.MessageType;
import com.lothrazar.simpletomb.helper.EntityHelper;
import com.lothrazar.simpletomb.item.GraveKeyItem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockTomb
extends BaseEntityBlock {
    public static final MapCodec<BlockTomb> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockTomb.propertiesCodec(), (App)ModelTomb.CODEC.fieldOf("model").forGetter(BlockTomb::getGraveType)).apply((Applicative)instance, BlockTomb::new));
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final IntegerProperty MODEL_TEXTURE = IntegerProperty.create((String)"model_texture", (int)0, (int)1);
    public static final BooleanProperty IS_ENGRAVED = BooleanProperty.create((String)"is_engraved");
    private static final VoxelShape GROUND = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    protected final String name;
    protected final ModelTomb graveModel;

    public BlockTomb(BlockBehaviour.Properties properties, ModelTomb graveModel) {
        super(properties.noOcclusion().strength(-1.0f, 3600000.0f));
        this.graveModel = graveModel;
        this.name = graveModel.getSerializedName();
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public MapCodec<BlockTomb> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return GROUND;
    }

    public ModelTomb getGraveType() {
        return this.graveModel;
    }

    public String getDescriptionId() {
        return "simpletomb.grave." + this.name;
    }

    public boolean dropFromExplosion(Explosion explosion) {
        return false;
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
    }

    public static BlockEntityTomb getBlockEntity(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        return blockEntity instanceof BlockEntityTomb ? (BlockEntityTomb)blockEntity : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlockEntityTomb(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockTomb.createTickerHelper(type, (BlockEntityType)((BlockEntityType)TombRegistry.TOMBSTONE_BLOCK_ENTITY.get()), (BlockEntityTicker)(level.isClientSide ? BlockEntityTomb::clientTick : BlockEntityTomb::serverTick));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING}).add(new Property[]{IS_ENGRAVED}).add(new Property[]{MODEL_TEXTURE});
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.isClientSide && entity.isShiftKeyDown() && entity.isAlive() && EntityHelper.isValidPlayer(entity)) {
            BlockTomb.activatePlayerGrave(level, pos, state, (Player)((ServerPlayer)entity));
        }
    }

    public static void activatePlayerGrave(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntityTomb tile = BlockTomb.getBlockEntity(level, pos);
        if (tile != null && player.isAlive()) {
            if (tile.onlyOwnersCanAccess() && !tile.isOwner(player)) {
                MessageType.MESSAGE_OPEN_GRAVE_NEED_OWNER.sendSpecialMessage(player, new Object[0]);
                return;
            }
            ((GraveKeyItem)((Object)TombRegistry.GRAVE_KEY.get())).removeKeyForGraveInInventory(player, new GlobalPos(level.dimension(), pos));
            tile.giveInventory(player);
            DeathHelper.INSTANCE.deleteLastGrave(player);
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockentity = level.getBlockEntity(pos);
            if (blockentity instanceof BlockEntityTomb) {
                BlockEntityTomb blockEntityTomb = (BlockEntityTomb)blockentity;
                blockEntityTomb.dropInventory(level, pos);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }
}

