/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.mojang.blaze3d.platform.InputConstants;
import cpw.mods.inventorysorter.Action;
import cpw.mods.inventorysorter.ContainerContext;
import cpw.mods.inventorysorter.InventorySorter;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.Slot;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.Level;

public class KeyHandler {
    private static KeyHandler keyHandler;
    private final Map<KeyMapping, Action> keyBindingMap;

    KeyHandler() {
        InputConstants.Type.MOUSE.getOrCreate(99);
        InputConstants.Type.MOUSE.getOrCreate(101);
        this.keyBindingMap = Stream.of(Action.values()).map(a -> new AbstractMap.SimpleEntry<Action, KeyMapping>((Action)((Object)a), new KeyMapping(a.getKeyBindingName(), (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.Type.MOUSE, a.getDefaultKeyCode(), "keygroup.inventorysorter"))).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        ScreenEventHandler eh = new ScreenEventHandler();
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, eh::onKey);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, eh::onMouse);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, eh::onScroll);
    }

    static void registerKeyHandlers(IEventBus bus) {
        if (FMLEnvironment.dist != Dist.CLIENT) {
            return;
        }
        keyHandler = new KeyHandler();
        bus.addListener(keyHandler::onKeyMappingEvent);
    }

    public void onKeyMappingEvent(RegisterKeyMappingsEvent evt) {
        this.keyBindingMap.keySet().forEach(arg_0 -> ((RegisterKeyMappingsEvent)evt).register(arg_0));
    }

    private boolean keyEvaluate(KeyMapping kb, ScreenEvent.KeyPressed.Pre evt) {
        return kb.matches(evt.getKeyCode(), evt.getScanCode());
    }

    private boolean mouseClickEvaluate(KeyMapping kb, ScreenEvent.MouseButtonPressed.Pre evt) {
        return kb.matchesMouse(evt.getButton());
    }

    private boolean mouseScrollEvaluate(KeyMapping kb, ScreenEvent.MouseScrolled.Pre evt) {
        int dir = (int)Math.signum(evt.getScrollDeltaY());
        int keycode = dir + 100;
        return kb.matchesMouse(keycode);
    }

    private <T extends ScreenEvent> void onInputEvent(T evt, BiPredicate<KeyMapping, T> kbTest) {
        Screen gui = evt.getScreen();
        if (!(gui instanceof AbstractContainerScreen) || gui instanceof CreativeModeInventoryScreen) {
            return;
        }
        AbstractContainerScreen guiContainer = (AbstractContainerScreen)gui;
        Slot slot = guiContainer.getSlotUnderMouse();
        if (!ContainerContext.validSlot(slot)) {
            InventorySorter.LOGGER.log(Level.DEBUG, "Skipping action handling for blacklisted slot");
            return;
        }
        Optional<Action> action = this.keyBindingMap.entrySet().stream().filter(e -> kbTest.test((KeyMapping)e.getKey(), evt)).map(Map.Entry::getValue).findFirst();
        if (!action.isPresent()) {
            return;
        }
        Action triggeredAction = action.get();
        if (triggeredAction.isActive() && guiContainer.getMenu() != null && guiContainer.getMenu().slots != null && guiContainer.getMenu().slots.contains((Object)slot)) {
            InventorySorter.LOGGER.debug("Sending action {} slot {}", (Object)triggeredAction, (Object)slot.index);
            PacketDistributor.sendToServer((CustomPacketPayload)triggeredAction.message(slot), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private class ScreenEventHandler {
        private ScreenEventHandler() {
        }

        private void onKey(ScreenEvent.KeyPressed.Pre evt) {
            KeyHandler.this.onInputEvent(evt, KeyHandler.this::keyEvaluate);
        }

        private void onMouse(ScreenEvent.MouseButtonPressed.Pre evt) {
            KeyHandler.this.onInputEvent(evt, KeyHandler.this::mouseClickEvaluate);
        }

        private void onScroll(ScreenEvent.MouseScrolled.Pre evt) {
            KeyHandler.this.onInputEvent(evt, KeyHandler.this::mouseScrollEvaluate);
        }
    }
}

