/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.injection.mixins.fast_buffer_upload;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexBuffer;
import java.nio.ByteBuffer;
import net.raphimc.immediatelyfast.ImmediatelyFast;
import org.lwjgl.opengl.GL15C;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={VertexBuffer.class}, priority=500)
public abstract class MixinVertexBuffer {
    @Unique
    private int immediatelyFast$vertexBufferSize;
    @Unique
    private int immediatelyFast$indexBufferSize;

    @Redirect(method={"uploadVertexBuffer(Lcom/mojang/blaze3d/vertex/MeshData$DrawState;Ljava/nio/ByteBuffer;)Lcom/mojang/blaze3d/vertex/VertexFormat;"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;glBufferData(ILjava/nio/ByteBuffer;I)V"))
    private void optimizeVertexDataUploading(int target, ByteBuffer data, int usage) {
        if (!ImmediatelyFast.runtimeConfig.fast_buffer_upload || data.remaining() > this.immediatelyFast$vertexBufferSize) {
            this.immediatelyFast$vertexBufferSize = data.remaining();
            RenderSystem.glBufferData((int)target, (ByteBuffer)data, (int)usage);
        } else {
            GL15C.glBufferSubData((int)target, (long)0L, (ByteBuffer)data);
        }
    }

    @Redirect(method={"uploadIndexBuffer(Lcom/mojang/blaze3d/vertex/ByteBufferBuilder$Result;)V", "uploadIndexBuffer(Lcom/mojang/blaze3d/vertex/MeshData$DrawState;Ljava/nio/ByteBuffer;)Lcom/mojang/blaze3d/systems/RenderSystem$AutoStorageIndexBuffer;"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;glBufferData(ILjava/nio/ByteBuffer;I)V"))
    private void optimizeIndexDataUploading(int target, ByteBuffer data, int usage) {
        if (!ImmediatelyFast.runtimeConfig.fast_buffer_upload || data.remaining() > this.immediatelyFast$indexBufferSize) {
            this.immediatelyFast$indexBufferSize = data.remaining();
            RenderSystem.glBufferData((int)target, (ByteBuffer)data, (int)usage);
        } else {
            GL15C.glBufferSubData((int)target, (long)0L, (ByteBuffer)data);
        }
    }
}

