/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.core;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceList;
import net.raphimc.immediatelyfast.ImmediatelyFast;

public class BufferAllocatorPool {
    private static final ReferenceList<ByteBufferBuilder> FREE = new ReferenceArrayList();
    private static final ReferenceList<ByteBufferBuilder> IN_USE = new ReferenceArrayList();
    private static final Reference2LongMap<ByteBufferBuilder> BUFFER_ALLOCATOR_ACCESS_TIME = new Reference2LongOpenHashMap();

    private BufferAllocatorPool() {
    }

    public static ByteBufferBuilder borrowBufferAllocator() {
        ByteBufferBuilder bufferAllocator;
        RenderSystem.assertOnRenderThread();
        if (FREE.isEmpty()) {
            bufferAllocator = new ByteBufferBuilder(256);
        } else {
            bufferAllocator = (ByteBufferBuilder)FREE.removeFirst();
            if (bufferAllocator.pointer == 0L) {
                BUFFER_ALLOCATOR_ACCESS_TIME.removeLong((Object)bufferAllocator);
                bufferAllocator = new ByteBufferBuilder(256);
            }
        }
        IN_USE.add((Object)bufferAllocator);
        BUFFER_ALLOCATOR_ACCESS_TIME.put((Object)bufferAllocator, System.currentTimeMillis());
        return bufferAllocator;
    }

    public static void returnBufferAllocatorSafe(ByteBufferBuilder bufferAllocator) {
        RenderSystem.assertOnRenderThread();
        if (!IN_USE.remove((Object)bufferAllocator)) {
            return;
        }
        bufferAllocator.discard();
        FREE.add((Object)bufferAllocator);
    }

    public static int getSize() {
        return FREE.size() + IN_USE.size();
    }

    public static void onEndFrame() {
        if (!IN_USE.isEmpty()) {
            ImmediatelyFast.LOGGER.warn(IN_USE.size() + " BufferAllocator(s) were not returned to the pool. Forcibly reclaiming them.");
            for (ByteBufferBuilder bufferAllocator : IN_USE) {
                bufferAllocator.discard();
            }
            FREE.addAll(IN_USE);
            IN_USE.clear();
        }
        BUFFER_ALLOCATOR_ACCESS_TIME.reference2LongEntrySet().removeIf(entry -> {
            if (System.currentTimeMillis() - entry.getLongValue() > 60000L) {
                if (FREE.contains(entry.getKey())) {
                    FREE.remove(entry.getKey());
                    ((ByteBufferBuilder)entry.getKey()).close();
                }
                return true;
            }
            return false;
        });
    }
}

