/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.server;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.LivingEntity;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.util.ISlotHelper;

public class SlotHelper
implements ISlotHelper {
    private final Map<String, ISlotType> idToType = new HashMap<String, ISlotType>();

    @Override
    public void addSlotType(ISlotType slotType) {
        this.idToType.put(slotType.getIdentifier(), slotType);
    }

    @Override
    public void clear() {
        this.idToType.clear();
    }

    @Override
    public Optional<ISlotType> getSlotType(String identifier) {
        return Optional.ofNullable(this.idToType.get(identifier));
    }

    @Override
    public Collection<ISlotType> getSlotTypes() {
        return Collections.unmodifiableCollection(this.idToType.values());
    }

    @Override
    public Collection<ISlotType> getSlotTypes(LivingEntity livingEntity) {
        return this.getSlotTypes();
    }

    @Override
    public Set<String> getSlotTypeIds() {
        return Collections.unmodifiableSet(this.idToType.keySet());
    }

    @Override
    public int getSlotsForType(@Nonnull LivingEntity livingEntity, String identifier) {
        return 0;
    }

    @Override
    public void setSlotsForType(String id, LivingEntity livingEntity, int amount) {
    }
}

