/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.network.server;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotAttribute;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.inventory.container.CuriosContainer;
import top.theillusivec4.curios.common.inventory.container.CuriosContainerProvider;
import top.theillusivec4.curios.common.network.client.CPacketDestroy;
import top.theillusivec4.curios.common.network.client.CPacketOpenCurios;
import top.theillusivec4.curios.common.network.client.CPacketOpenVanilla;
import top.theillusivec4.curios.common.network.client.CPacketPage;
import top.theillusivec4.curios.common.network.client.CPacketToggleCosmetics;
import top.theillusivec4.curios.common.network.client.CPacketToggleRender;
import top.theillusivec4.curios.common.network.server.SPacketGrabbedItem;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncRender;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncStack;

public class CuriosServerPayloadHandler {
    private static final CuriosServerPayloadHandler INSTANCE = new CuriosServerPayloadHandler();

    public static CuriosServerPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handlerToggleRender(CPacketToggleRender data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(handler -> handler.getStacksHandler(data.identifier())).ifPresent(stacksHandler -> {
                NonNullList<Boolean> renderStatuses = stacksHandler.getRenders();
                if (renderStatuses.size() > data.index()) {
                    boolean value = (Boolean)renderStatuses.get(data.index()) == false;
                    renderStatuses.set(data.index(), (Object)value);
                    PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)new SPacketSyncRender(player.getId(), data.identifier(), data.index(), value), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            });
        });
    }

    public void handlePage(CPacketPage data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            AbstractContainerMenu container = player.containerMenu;
            if (container instanceof CuriosContainer && container.containerId == data.windowId()) {
                if (data.next()) {
                    ((CuriosContainer)container).nextPage();
                } else {
                    ((CuriosContainer)container).prevPage();
                }
            }
        });
    }

    public void handlerToggleCosmetics(CPacketToggleCosmetics data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            AbstractContainerMenu container = player.containerMenu;
            if (container instanceof CuriosContainer && container.containerId == data.windowId()) {
                ((CuriosContainer)container).toggleCosmetics();
            }
        });
    }

    public void handleOpenVanilla(CPacketOpenVanilla data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ItemStack stack = player.isCreative() ? data.carried() : player.containerMenu.getCarried();
                player.containerMenu.setCarried(ItemStack.EMPTY);
                serverPlayer.doCloseContainer();
                if (!stack.isEmpty()) {
                    if (!player.isCreative()) {
                        player.containerMenu.setCarried(stack);
                    }
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SPacketGrabbedItem(stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        });
    }

    public void handleOpenCurios(CPacketOpenCurios data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ItemStack stack = player.isCreative() ? data.carried() : player.containerMenu.getCarried();
                player.containerMenu.setCarried(ItemStack.EMPTY);
                player.openMenu((MenuProvider)new CuriosContainerProvider());
                if (!stack.isEmpty()) {
                    player.containerMenu.setCarried(stack);
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SPacketGrabbedItem(stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        });
    }

    public void handleDestroyPacket(CPacketDestroy data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> handler.getCurios().values().forEach(stacksHandler -> {
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                IDynamicStackHandler cosmeticStackHandler = stacksHandler.getCosmeticStacks();
                String id = stacksHandler.getIdentifier();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    NonNullList<Boolean> renderStates = stacksHandler.getRenders();
                    SlotContext slotContext = new SlotContext(id, (LivingEntity)player, i, false, renderStates.size() > i && (Boolean)renderStates.get(i) != false);
                    ResourceLocation slotId = CuriosApi.getSlotId(slotContext);
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    Multimap<Holder<Attribute>, AttributeModifier> map = CuriosApi.getAttributeModifiers(slotContext, slotId, stack);
                    HashMultimap slots = HashMultimap.create();
                    HashSet<Holder> toRemove = new HashSet<Holder>();
                    AttributeMap attributeMap = player.getAttributes();
                    for (Holder attribute : map.keySet()) {
                        Object patt0$temp = attribute.value();
                        if (!(patt0$temp instanceof SlotAttribute)) continue;
                        SlotAttribute wrapper = (SlotAttribute)((Object)((Object)((Object)((Object)patt0$temp))));
                        slots.putAll((Object)wrapper.getIdentifier(), (Iterable)map.get((Object)attribute));
                        toRemove.add(attribute);
                    }
                    for (Holder attribute : toRemove) {
                        map.removeAll((Object)attribute);
                    }
                    map.forEach((key, value) -> {
                        AttributeInstance attInst = attributeMap.getInstance(key);
                        if (attInst != null) {
                            attInst.removeModifier(value);
                        }
                    });
                    handler.removeSlotModifiers((Multimap<String, AttributeModifier>)slots);
                    CuriosApi.getCurio(stack).ifPresent(curio -> curio.onUnequip(slotContext, stack));
                    stackHandler.setStackInSlot(i, ItemStack.EMPTY);
                    PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)new SPacketSyncStack(player.getId(), id, i, ItemStack.EMPTY, SPacketSyncStack.HandlerType.EQUIPMENT.ordinal(), new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    cosmeticStackHandler.setStackInSlot(i, ItemStack.EMPTY);
                    PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)new SPacketSyncStack(player.getId(), id, i, ItemStack.EMPTY, SPacketSyncStack.HandlerType.COSMETIC.ordinal(), new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }));
        });
    }
}

