/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.inventory;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.items.ItemStackHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.event.CurioCanEquipEvent;
import top.theillusivec4.curios.api.event.CurioCanUnequipEvent;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class DynamicStackHandler
extends ItemStackHandler
implements IDynamicStackHandler {
    protected NonNullList<ItemStack> previousStacks;
    protected Function<Integer, SlotContext> ctxBuilder;

    public DynamicStackHandler(int size, Function<Integer, SlotContext> ctxBuilder) {
        super(size);
        this.previousStacks = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        this.ctxBuilder = ctxBuilder;
    }

    @Override
    public void setPreviousStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.validateSlotIndex(slot);
        this.previousStacks.set(slot, (Object)stack);
        this.onContentsChanged(slot);
    }

    @Override
    @Nonnull
    public ItemStack getPreviousStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return (ItemStack)this.previousStacks.get(slot);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        SlotContext ctx = this.ctxBuilder.apply(slot);
        TriState canEquip = CuriosApi.isStackValid(ctx, stack) && CuriosApi.getCurio(stack).map(curio -> curio.canEquip(ctx)).orElse(true) != false && super.isItemValid(slot, stack) ? TriState.TRUE : TriState.FALSE;
        CurioCanEquipEvent equipEvent = new CurioCanEquipEvent(stack, ctx, canEquip);
        NeoForge.EVENT_BUS.post((Event)equipEvent);
        return equipEvent.getEquipResult() != TriState.FALSE;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        Player player;
        boolean isCreative;
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        SlotContext ctx = this.ctxBuilder.apply(slot);
        CurioCanUnequipEvent unequipEvent = new CurioCanUnequipEvent(existing, ctx);
        NeoForge.EVENT_BUS.post((Event)unequipEvent);
        TriState result = unequipEvent.getUnequipResult();
        if (result == TriState.FALSE) {
            return ItemStack.EMPTY;
        }
        LivingEntity livingEntity = ctx.entity();
        boolean bl = isCreative = livingEntity instanceof Player && (player = (Player)livingEntity).isCreative();
        if (result == TriState.TRUE || (existing.isEmpty() || isCreative || !EnchantmentHelper.has((ItemStack)existing, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) && CuriosApi.getCurio(existing).map(curio -> curio.canUnequip(ctx)).orElse(true).booleanValue()) {
            return super.extractItem(slot, amount, simulate);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void grow(int amount) {
        this.stacks = DynamicStackHandler.getResizedList(this.stacks.size() + amount, (NonNullList<ItemStack>)this.stacks);
        this.previousStacks = DynamicStackHandler.getResizedList(this.previousStacks.size() + amount, this.previousStacks);
    }

    @Override
    public void shrink(int amount) {
        this.stacks = DynamicStackHandler.getResizedList(this.stacks.size() - amount, (NonNullList<ItemStack>)this.stacks);
        this.previousStacks = DynamicStackHandler.getResizedList(this.previousStacks.size() - amount, this.previousStacks);
    }

    private static NonNullList<ItemStack> getResizedList(int size, NonNullList<ItemStack> stacks) {
        NonNullList newList = NonNullList.withSize((int)Math.max(0, size), (Object)ItemStack.EMPTY);
        for (int i = 0; i < newList.size() && i < stacks.size(); ++i) {
            newList.set(i, (Object)((ItemStack)stacks.get(i)));
        }
        return newList;
    }
}

