/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.client;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotAttribute;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.client.KeyRegistry;
import top.theillusivec4.curios.common.network.client.CPacketOpenCurios;

public class ClientEventHandler {
    private static final ResourceLocation ATTACK_DAMAGE_MODIFIER = ResourceLocation.fromNamespaceAndPath((String)"curios", (String)"attack_damage_modifier");
    private static final ResourceLocation ATTACK_SPEED_MODIFIER = ResourceLocation.fromNamespaceAndPath((String)"curios", (String)"attack_speed_modifier");

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Post evt) {
        Minecraft mc = Minecraft.getInstance();
        if (KeyRegistry.openCurios.consumeClick() && mc.isWindowActive()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new CPacketOpenCurios(ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent evt) {
        ItemStack stack = evt.getItemStack();
        Player player = evt.getEntity();
        if (!stack.isEmpty()) {
            ArrayList<String> slots;
            List tooltip = evt.getToolTip();
            for (int i = 0; i < tooltip.size(); ++i) {
                Component component = (Component)tooltip.get(i);
                ComponentContents componentContents = component.getContents();
                if (!(componentContents instanceof TranslatableContents)) continue;
                TranslatableContents contents = (TranslatableContents)componentContents;
                boolean replace = false;
                Object[] args = contents.getArgs();
                if (args != null) {
                    for (int i1 = 0; i1 < args.length; ++i1) {
                        TranslatableContents contents1;
                        MutableComponent mutableComponent;
                        ComponentContents componentContents2;
                        Object arg = args[i1];
                        if (!(arg instanceof MutableComponent) || !((componentContents2 = (mutableComponent = (MutableComponent)arg).getContents()) instanceof TranslatableContents) || !(contents1 = (TranslatableContents)componentContents2).getKey().startsWith("curios.slot.")) continue;
                        String actualKey = contents1.getKey().replace(".slot.", ".identifier.");
                        contents.getArgs()[i1] = Component.translatable((String)actualKey, (Object[])contents1.getArgs());
                        replace = true;
                        break;
                    }
                }
                if (!replace) continue;
                tooltip.set(i, Component.translatable((String)contents.getKey().replace("attribute.modifier.", "curios.modifiers.slots."), (Object[])contents.getArgs()).withStyle(component.getStyle()));
            }
            Map<String, ISlotType> map = player != null ? CuriosApi.getItemStackSlots(stack, (LivingEntity)player) : CuriosApi.getItemStackSlots(stack, FMLLoader.getDist() == Dist.CLIENT);
            Set<String> curioTags = Set.copyOf(map.keySet());
            if (curioTags.contains("curio")) {
                curioTags = Set.of("curio");
            }
            if (!(slots = new ArrayList<String>(curioTags)).isEmpty()) {
                ArrayList<MutableComponent> tagTooltips = new ArrayList<MutableComponent>();
                MutableComponent slotsTooltip = Component.translatable((String)"curios.tooltip.slot").append(" ").withStyle(ChatFormatting.GOLD);
                for (int j = 0; j < slots.size(); ++j) {
                    String key = "curios.identifier." + (String)slots.get(j);
                    MutableComponent type = Component.translatable((String)key);
                    if (j < slots.size() - 1) {
                        type = type.append(", ");
                    }
                    type = type.withStyle(ChatFormatting.YELLOW);
                    slotsTooltip.append((Component)type);
                }
                tagTooltips.add(slotsTooltip);
                Optional<ICurio> optionalCurio = CuriosApi.getCurio(stack);
                optionalCurio.ifPresent(curio -> {
                    List<Component> actualSlotsTooltip = curio.getSlotsTooltip(tagTooltips);
                    if (!actualSlotsTooltip.isEmpty()) {
                        tooltip.addAll(1, actualSlotsTooltip);
                    }
                });
                if (optionalCurio.isEmpty()) {
                    tooltip.addAll(1, tagTooltips);
                }
                ArrayList<MutableComponent> attributeTooltip = new ArrayList<MutableComponent>();
                for (String identifier : slots) {
                    Multimap<Holder<Attribute>, AttributeModifier> multimap = CuriosApi.getAttributeModifiers(new SlotContext(identifier, (LivingEntity)player, 0, false, true), ResourceLocation.fromNamespaceAndPath((String)"curios", (String)identifier), stack);
                    if (multimap.isEmpty()) continue;
                    boolean init = false;
                    for (Map.Entry entry : multimap.entries()) {
                        if (entry.getKey() == null) continue;
                        if (!init) {
                            attributeTooltip.add(Component.empty());
                            attributeTooltip.add(Component.translatable((String)("curios.modifiers." + identifier)).withStyle(ChatFormatting.GOLD));
                            init = true;
                        }
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        double amount = attributemodifier.amount();
                        boolean flag = false;
                        if (player == null) continue;
                        if (attributemodifier.is(ATTACK_DAMAGE_MODIFIER)) {
                            Level level;
                            AttributeInstance att = player.getAttribute(Attributes.ATTACK_DAMAGE);
                            if (att != null) {
                                amount += att.getBaseValue();
                            }
                            if ((level = player.level()) instanceof ServerLevel) {
                                ServerLevel serverLevel = (ServerLevel)level;
                                amount = EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)stack, null, (DamageSource)player.damageSources().generic(), (float)((float)amount));
                            }
                            flag = true;
                        } else if (attributemodifier.is(ATTACK_SPEED_MODIFIER)) {
                            AttributeInstance att = player.getAttribute(Attributes.ATTACK_SPEED);
                            if (att != null) {
                                amount += att.getBaseValue();
                            }
                            flag = true;
                        }
                        double d1 = attributemodifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_BASE && attributemodifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? (((Holder)entry.getKey()).equals((Object)Attributes.KNOCKBACK_RESISTANCE) ? amount * 10.0 : amount) : amount * 100.0;
                        Object object = ((Holder)entry.getKey()).value();
                        if (object instanceof SlotAttribute) {
                            SlotAttribute slotAttribute = (SlotAttribute)((Object)object);
                            if (amount > 0.0) {
                                attributeTooltip.add(Component.translatable((String)("curios.modifiers.slots.plus." + attributemodifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d1), Component.translatable((String)("curios.identifier." + slotAttribute.getIdentifier()))}).withStyle(ChatFormatting.BLUE));
                                continue;
                            }
                            attributeTooltip.add(Component.translatable((String)("curios.modifiers.slots.take." + attributemodifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d1 *= -1.0), Component.translatable((String)("curios.identifier." + slotAttribute.getIdentifier()))}).withStyle(ChatFormatting.RED));
                            continue;
                        }
                        if (flag) {
                            attributeTooltip.add(Component.literal((String)" ").append((Component)Component.translatable((String)("attribute.modifier.equals." + attributemodifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d1), Component.translatable((String)((Attribute)((Holder)entry.getKey()).value()).getDescriptionId())})).withStyle(ChatFormatting.DARK_GREEN));
                            continue;
                        }
                        if (amount > 0.0) {
                            attributeTooltip.add(Component.translatable((String)("attribute.modifier.plus." + attributemodifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d1), Component.translatable((String)((Attribute)((Holder)entry.getKey()).value()).getDescriptionId())}).withStyle(ChatFormatting.BLUE));
                            continue;
                        }
                        if (!(amount < 0.0)) continue;
                        attributeTooltip.add(Component.translatable((String)("attribute.modifier.take." + attributemodifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d1 *= -1.0), Component.translatable((String)((Attribute)((Holder)entry.getKey()).value()).getDescriptionId())}).withStyle(ChatFormatting.RED));
                    }
                }
                optionalCurio.ifPresent(curio -> {
                    List<Component> actualAttributeTooltips = curio.getAttributesTooltip(attributeTooltip);
                    if (!actualAttributeTooltips.isEmpty()) {
                        tooltip.addAll(actualAttributeTooltips);
                    }
                });
                if (optionalCurio.isEmpty()) {
                    tooltip.addAll(attributeTooltip);
                }
            }
        }
    }
}

