/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.chisel.item;

import com.matthewperiut.chisel.Chisel;
import com.matthewperiut.chisel.block.ChiselGroupLookup;
import com.matthewperiut.chisel.gui.ChiselScreenHandler;
import com.matthewperiut.chisel.inventory.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ChiselItem
extends BundleItem
implements MenuProvider {
    public static ArrayList<TimeSinceUse> timeSinceUses = new ArrayList();

    public ChiselItem(Item.Properties settings) {
        super(settings);
    }

    public boolean isBarVisible(ItemStack stack) {
        return false;
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction clickType, Player player) {
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.pass((Object)user.getItemInHand(hand));
        }
        if (!world.isClientSide && user.getMainHandItem().is((Item)Chisel.chiselSupplier.get())) {
            user.openMenu((MenuProvider)this);
        }
        return InteractionResultHolder.sidedSuccess((Object)user.getItemInHand(hand), (boolean)false);
    }

    public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
        ItemStack stack = (ItemStack)player.getHandSlots().iterator().next();
        BundleContents bundleContentsComponent = (BundleContents)stack.getOrDefault(DataComponents.BUNDLE_CONTENTS, (Object)new BundleContents(new ArrayList()));
        assert (bundleContentsComponent != null);
        Container chiselInv = InventoryUtil.createInventory(bundleContentsComponent);
        return new ChiselScreenHandler(syncId, inv, chiselInv, bundleContentsComponent);
    }

    public InteractionResult useOn(UseOnContext context) {
        return InteractionResult.PASS;
    }

    public static void chiselSound(Level world, BlockPos pos) {
        if (!world.isClientSide) {
            world.playSound(null, pos, Chisel.CHISEL_SOUND_EVENT, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public boolean canAttackBlock(BlockState state, Level world, BlockPos pos, Player miner) {
        if (!world.isClientSide) {
            ItemStack inHand;
            BundleContents bcc;
            boolean found = false;
            for (TimeSinceUse u : timeSinceUses) {
                if (!u.player.equals((Object)miner)) continue;
                found = true;
                if (world.getGameTime() - u.time < 5L) {
                    return false;
                }
                u.time = world.getGameTime();
            }
            if (!found) {
                timeSinceUses.add(new TimeSinceUse(this, miner, world.getGameTime()));
            }
            if ((bcc = (BundleContents)(inHand = (ItemStack)miner.getHandSlots().iterator().next()).getOrDefault(DataComponents.BUNDLE_CONTENTS, (Object)new BundleContents(new ArrayList(0)))).isEmpty()) {
                List<Item> items = ChiselGroupLookup.getBlocksInGroup(state.getBlock().asItem());
                if (!items.isEmpty()) {
                    ResourceLocation block = BuiltInRegistries.ITEM.getKey((Object)items.get(world.random.nextInt(items.size())));
                    world.setBlockAndUpdate(pos, ((Block)BuiltInRegistries.BLOCK.get(block)).defaultBlockState());
                    ChiselItem.chiselSound(world, pos);
                }
                return false;
            }
            ItemStack itemStack = bcc.getItemUnsafe(0);
            ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
            ResourceLocation inInventory = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
            String[] compare = new String[2];
            String[] temp = inInventory.getPath().split("/");
            compare[0] = temp[temp.length - 1];
            temp = blockId.getPath().split("/");
            compare[1] = temp[temp.length - 1];
            if (compare[1].contains("stairs")) {
                return false;
            }
            if (compare[0].contains(compare[1]) || compare[1].contains(compare[0])) {
                world.setBlockAndUpdate(pos, ((Block)BuiltInRegistries.BLOCK.get(inInventory)).defaultBlockState());
                ChiselItem.chiselSound(world, pos);
            }
        }
        return false;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        Item item = state.getBlock().asItem();
        if (!(item instanceof BlockItem)) {
            Chisel.LOGGER.info("How is " + item.getDescription().getString() + " not a blockItem?");
            return 1.0f;
        }
        return 500.0f;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"gui.chisel.chisel");
    }

    class TimeSinceUse {
        public Player player;
        public Long time;

        TimeSinceUse(ChiselItem this$0, Player player, Long time) {
            this.player = player;
            this.time = time;
        }
    }
}

