/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.chisel.inventory;

import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface IInventory
extends Container {
    public NonNullList<ItemStack> getItems();

    public static IInventory of(NonNullList<ItemStack> items) {
        return () -> items;
    }

    public static IInventory ofSize(int size) {
        return IInventory.of((NonNullList<ItemStack>)NonNullList.withSize((int)size, (Object)ItemStack.EMPTY));
    }

    default public int getContainerSize() {
        return this.getItems().size();
    }

    default public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    default public ItemStack getItem(int slot) {
        return (ItemStack)this.getItems().get(slot);
    }

    default public ItemStack removeItem(int slot, int count) {
        ItemStack result = ContainerHelper.removeItem(this.getItems(), (int)slot, (int)count);
        if (!result.isEmpty()) {
            this.setChanged();
        }
        return result;
    }

    default public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.getItems(), (int)slot);
    }

    default public void setItem(int slot, ItemStack stack) {
        this.getItems().set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
    }

    default public void clearContent() {
        this.getItems().clear();
    }

    default public void setChanged() {
    }

    default public boolean stillValid(Player player) {
        return true;
    }
}

