/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.chisel.gui;

import com.matthewperiut.chisel.Chisel;
import com.matthewperiut.chisel.inventory.ChiselInventory;
import com.matthewperiut.chisel.inventory.InventoryUtil;
import com.matthewperiut.chisel.item.ChiselItem;
import java.time.LocalTime;
import java.util.ArrayList;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;

public class ChiselScreenHandler
extends AbstractContainerMenu {
    private final ChiselInventory inventory;
    private final BundleContents componentInventory;
    LocalTime currentTime = LocalTime.now();

    public ChiselScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, new ChiselInventory());
    }

    public ChiselScreenHandler(int syncId, Inventory playerInventory, Container inventory) {
        this(syncId, playerInventory, inventory, new BundleContents(new ArrayList()));
    }

    public ChiselScreenHandler(int syncId, Inventory playerInventory, Container inventory, BundleContents component) {
        super((MenuType)Chisel.CHISEL_SCREEN_HANDLER.get(), syncId);
        int y;
        int x;
        ChiselScreenHandler.checkContainerSize((Container)inventory, (int)61);
        this.inventory = (ChiselInventory)inventory;
        this.componentInventory = component;
        this.addSlot(new Slot(inventory, 0, 8, 145));
        for (x = 0; x < 10; ++x) {
            for (y = 0; y < 6; ++y) {
                this.addSlot(new SlotChiselOutput(inventory, 1 + x + 10 * y, 62 + 18 * x - 54, 8 + 18 * y + 7));
            }
        }
        for (x = 0; x < 9; ++x) {
            for (y = 0; y < 3; ++y) {
                this.addSlot(new Slot((Container)playerInventory, 9 + x + 9 * y, 71 + 18 * x - 45, 120 + 18 * y + 7));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)playerInventory, x, 71 + 18 * x - 45, 185));
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player player, int invSlot) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(invSlot);
        if (slot != null && slot.hasItem()) {
            ItemStack originalStack = slot.getItem();
            newStack = originalStack.copy();
            if (originalStack.getItem().equals(Chisel.chiselSupplier.get())) {
                return ItemStack.EMPTY;
            }
            if (invSlot < this.inventory.getContainerSize()) {
                if (invSlot != 0) {
                    originalStack.setCount(((Slot)this.slots.get(0)).getItem().getCount());
                    ChiselItem.chiselSound(player.level(), player.blockPosition());
                }
                if (!this.moveItemStackTo(originalStack, this.inventory.getContainerSize(), this.slots.size(), true)) {
                    this.inventory.refresh(((Slot)this.slots.get(0)).getItem().getItem());
                    return ItemStack.EMPTY;
                }
                this.inventory.clearContent();
            } else if (!this.moveItemStackTo(originalStack, 0, 1, false)) {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }

    public void removed(Player player) {
        super.removed(player);
        ItemStack hand = (ItemStack)player.getHandSlots().iterator().next();
        if (!hand.is((Item)Chisel.chiselSupplier.get())) {
            ItemStack itemStack = ItemStack.EMPTY;
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                if (!player.getInventory().getItem(i).is((Item)Chisel.chiselSupplier.get())) continue;
                itemStack = player.getInventory().getItem(i);
                player.getInventory().removeItemNoUpdate(i);
            }
            player.getInventory().setItem(0, itemStack);
        }
        if (this.inventory.isEmpty()) {
            c = InventoryUtil.createBundleComponent(this.inventory);
            DataComponentPatch changes = DataComponentPatch.builder().remove(DataComponents.BUNDLE_CONTENTS).build();
            hand.applyComponentsAndValidate(changes);
        } else {
            c = InventoryUtil.createBundleComponent(this.inventory);
            DataComponentPatch changes = DataComponentPatch.builder().remove(DataComponents.BUNDLE_CONTENTS).set(DataComponents.BUNDLE_CONTENTS, (Object)c).build();
            hand.applyComponentsAndValidate(changes);
        }
    }

    public void clicked(int i, int j, ClickType actionType, Player playerEntity) {
        Slot slot;
        if (i >= 0 && i < this.slots.size() && (slot = (Slot)this.slots.get(i)).getItem().getItem() instanceof ChiselItem) {
            return;
        }
        super.clicked(i, j, actionType, playerEntity);
    }

    private static class SlotChiselOutput
    extends Slot {
        public SlotChiselOutput(Container inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public void onTake(Player player, ItemStack stack) {
            this.container.clearContent();
            super.onTake(player, stack);
        }

        public boolean mayPlace(ItemStack stack) {
            return false;
        }

        public int getMaxStackSize() {
            return 64;
        }
    }
}

