/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.chisel.gui;

import com.matthewperiut.chisel.mixins.HandledScreenAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ChiselScreen
extends AbstractContainerScreen<AbstractContainerMenu> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"chisel", (String)"textures/chiselfabricgui.png");
    public static final int TEXTURE_WIDTH = 194;
    public static final int TEXTURE_HEIGHT = 209;

    public ChiselScreen(AbstractContainerMenu handler, Inventory inventory, Component title) {
        super(handler, inventory, title);
        this.titleLabelY = 5;
        this.imageWidth = 194;
        this.imageHeight = 209;
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        context.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.renderBackground(context, mouseX, mouseY, delta);
        super.render(context, mouseX, mouseY, delta);
        this.renderTooltip(context, mouseX, mouseY);
    }

    protected void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
    }

    protected void renderLabels(GuiGraphics context, int mouseX, int mouseY) {
        context.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
    }

    protected void renderSlot(GuiGraphics context, Slot slot) {
        Pair pair;
        int k;
        int i = slot.x;
        int j = slot.y;
        ItemStack itemStack = slot.getItem();
        boolean bl = false;
        boolean bl2 = slot == ((HandledScreenAccessor)((Object)this)).getTouchDragSlotStart() && !((HandledScreenAccessor)((Object)this)).getTouchDragStack().isEmpty() && !((HandledScreenAccessor)((Object)this)).getTouchIsRightClickDrag();
        ItemStack itemStack2 = this.menu.getCarried();
        String string = null;
        if (slot == ((HandledScreenAccessor)((Object)this)).getTouchDragSlotStart() && !((HandledScreenAccessor)((Object)this)).getTouchDragStack().isEmpty() && ((HandledScreenAccessor)((Object)this)).getTouchIsRightClickDrag() && !itemStack.isEmpty()) {
            itemStack = itemStack.copyWithCount(itemStack.getCount() / 2);
        } else if (this.isQuickCrafting && this.quickCraftSlots.contains(slot) && !itemStack2.isEmpty()) {
            if (this.quickCraftSlots.size() == 1) {
                return;
            }
            if (AbstractContainerMenu.canItemQuickReplace((Slot)slot, (ItemStack)itemStack2, (boolean)true) && this.menu.canDragTo(slot)) {
                bl = true;
                k = Math.min(itemStack2.getMaxStackSize(), slot.getMaxStackSize(itemStack2));
                int l = slot.getItem().isEmpty() ? 0 : slot.getItem().getCount();
                int m = AbstractContainerMenu.getQuickCraftPlaceCount((Set)this.quickCraftSlots, (int)((HandledScreenAccessor)((Object)this)).getHeldButtonType(), (ItemStack)itemStack2) + l;
                if (m > k) {
                    m = k;
                    String var10000 = ChatFormatting.YELLOW.toString();
                    string = var10000 + k;
                }
                itemStack = itemStack2.copyWithCount(m);
            } else {
                this.quickCraftSlots.remove(slot);
                ((HandledScreenAccessor)((Object)this)).invokeCalculateOffset();
            }
        }
        context.pose().pushPose();
        context.pose().translate(0.0f, 0.0f, 100.0f);
        if (itemStack.isEmpty() && slot.isActive() && (pair = slot.getNoItemIcon()) != null) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)this.minecraft.getTextureAtlas((ResourceLocation)pair.getFirst()).apply((ResourceLocation)pair.getSecond());
            context.blit(i, j, 0, 16, 16, sprite);
            bl2 = true;
        }
        if (!bl2) {
            if (bl) {
                context.fill(i, j, i + 16, j + 16, -2130706433);
            }
            k = slot.x + slot.y * this.imageWidth;
            if (slot.isFake()) {
                context.renderFakeItem(itemStack, i, j, k);
            } else {
                context.renderItem(itemStack, i, j, k);
            }
            if (slot.index < 1 || slot.index > 61) {
                context.renderItemDecorations(this.font, itemStack, i, j, string);
            }
        }
        context.pose().popPose();
    }
}

