/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.vanilla;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.model.ModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.api.model.SpriteIdentifier;
import com.supermartijn642.fusion.model.types.vanilla.VanillaModelSerializer;
import java.util.Collection;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.model.ExtendedBlockModelDeserializer;
import org.jetbrains.annotations.Nullable;

public class VanillaModelType
implements ModelType<BlockModel> {
    @Override
    public Collection<ResourceLocation> getModelDependencies(BlockModel data) {
        return data.getDependencies();
    }

    @Override
    public BakedModel bake(ModelBakingContext context, BlockModel data) {
        ModelInstance<?> model;
        if (data.parentLocation != null && data.parent == null && (model = context.getModel(data.parentLocation)) != null) {
            data.parent = model.getAsVanillaModel();
        }
        return data.bake(context.getModelBaker(), material -> context.getTexture(SpriteIdentifier.of(material)), context.getTransformation());
    }

    @Override
    @Nullable
    public BlockModel getAsVanillaModel(BlockModel data) {
        return data;
    }

    @Override
    public BlockModel deserialize(JsonObject json) throws JsonParseException {
        return (BlockModel)ExtendedBlockModelDeserializer.INSTANCE.fromJson((JsonElement)json, BlockModel.class);
    }

    @Override
    public JsonObject serialize(BlockModel value) {
        return (JsonObject)VanillaModelSerializer.GSON.toJsonTree((Object)value);
    }
}

