/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.items;

import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.blockentities.BlockEntityFrequencyOwner;
import edivad.dimstorage.items.components.DimStorageComponents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ItemDimBase
extends BlockItem {
    public ItemDimBase(Block block, Item.Properties properties) {
        super(block, properties);
    }

    private Frequency getFreq(ItemStack stack) {
        return (Frequency)stack.getOrDefault(DimStorageComponents.FREQUENCY, (Object)new Frequency());
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        if (super.placeBlock(context, state)) {
            Level level = context.getLevel();
            BlockPos pos = context.getClickedPos();
            ItemStack stack = context.getItemInHand();
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof BlockEntityFrequencyOwner) {
                BlockEntityFrequencyOwner b = (BlockEntityFrequencyOwner)blockEntity;
                b.setFrequency(this.getFreq(stack));
                return true;
            }
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        Frequency frequency = this.getFreq(stack);
        if (frequency.hasOwner()) {
            tooltip.add((Component)Component.translatable((String)"gui.dimstorage.owner").append(" " + frequency.getOwner()).withStyle(ChatFormatting.DARK_RED));
        }
        if (stack.has(DimStorageComponents.FREQUENCY)) {
            tooltip.add((Component)Component.translatable((String)"gui.dimstorage.frequency").append(" " + frequency.channel()));
        }
    }
}

