/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.mods.structureexpansion.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class CommandClean {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"clean").requires(cs -> cs.hasPermission(2))).then(Commands.argument((String)"structure_file", (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandClean.cleanStruc((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"structure_file"))));
    }

    private static int cleanStruc(CommandSourceStack source, String file) {
        ServerLevel worldServer = source.getLevel();
        StructureTemplateManager templateManager = worldServer.getStructureManager();
        ResourceLocation name = ResourceLocation.withDefaultNamespace((String)file);
        StructureTemplate template = templateManager.getOrCreate(name);
        template.palettes.forEach(e -> {
            int preSize = e.blocks().size();
            e.blocks().removeIf(a -> a.state().getBlock() == Blocks.AIR);
            int removed = preSize - e.blocks().size();
            source.sendSuccess(() -> Component.literal((String)("Removed " + removed + " air blocks")), true);
        });
        templateManager.save(name);
        return 1;
    }
}

