/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.gigaherz.toolbelt.BeltFinder;
import dev.gigaherz.toolbelt.ConfigData;
import dev.gigaherz.toolbelt.client.ClientEvents;
import dev.gigaherz.toolbelt.client.radial.GenericRadialMenu;
import dev.gigaherz.toolbelt.client.radial.IRadialMenuHost;
import dev.gigaherz.toolbelt.client.radial.ItemStackRadialMenuItem;
import dev.gigaherz.toolbelt.client.radial.RadialMenuItem;
import dev.gigaherz.toolbelt.client.radial.TextRadialMenuItem;
import dev.gigaherz.toolbelt.network.SwapItems;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(value={Dist.CLIENT})
public class RadialMenuScreen
extends Screen {
    private final BeltFinder.BeltGetter getter;
    private ItemStack stackEquipped;
    private IItemHandler inventory;
    private boolean keyCycleBeforeL = false;
    private boolean keyCycleBeforeR = false;
    private boolean needsRecheckStacks = true;
    private final List<ItemStackRadialMenuItem> cachedMenuItems = Lists.newArrayList();
    private final TextRadialMenuItem insertMenuItem;
    private final GenericRadialMenu menu;

    public RadialMenuScreen(BeltFinder.BeltGetter getter) {
        super((Component)Component.literal((String)"RADIAL MENU"));
        this.getter = getter;
        this.stackEquipped = getter.getBelt();
        this.inventory = this.stackEquipped.getCount() > 0 ? (IItemHandler)this.stackEquipped.getCapability(Capabilities.ItemHandler.ITEM) : null;
        this.menu = new GenericRadialMenu(this, Minecraft.getInstance(), new IRadialMenuHost(){

            @Override
            public void renderTooltip(GuiGraphics graphics, ItemStack stack, int mouseX, int mouseY) {
                graphics.renderTooltip(RadialMenuScreen.this.font, stack, mouseX, mouseY);
            }

            @Override
            public Screen getScreen() {
                return RadialMenuScreen.this;
            }

            @Override
            public Font getFontRenderer() {
                return RadialMenuScreen.this.font;
            }
        }){

            @Override
            public void onClickOutside() {
                this.close();
            }
        };
        this.insertMenuItem = new TextRadialMenuItem(this.menu, (Component)Component.translatable((String)"text.toolbelt.insert")){

            @Override
            public boolean onClick() {
                return RadialMenuScreen.this.trySwap(-1, ItemStack.EMPTY);
            }
        };
    }

    @SubscribeEvent
    public static void overlayEvent(RenderGuiLayerEvent.Pre event) {
        if (!event.getName().equals((Object)VanillaGuiLayers.CROSSHAIR)) {
            return;
        }
        if (Minecraft.getInstance().screen instanceof RadialMenuScreen) {
            event.setCanceled(true);
        }
    }

    public void removed() {
        super.removed();
        ClientEvents.wipeOpen();
    }

    public void tick() {
        super.tick();
        this.menu.tick();
        if (this.menu.isClosed()) {
            Minecraft.getInstance().setScreen(null);
            ClientEvents.wipeOpen();
        }
        if (!this.menu.isReady() || this.inventory == null) {
            return;
        }
        ItemStack inHand = this.minecraft.player.getMainHandItem();
        if (!ConfigData.isItemStackAllowed(inHand)) {
            this.inventory = null;
        } else {
            ItemStack stack = this.getter.getBelt();
            if (stack.getCount() <= 0) {
                this.inventory = null;
                this.stackEquipped = null;
            } else if (this.stackEquipped != stack) {
                this.stackEquipped = stack;
                this.inventory = Objects.requireNonNull((IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM));
                this.needsRecheckStacks = true;
            }
        }
        if (this.inventory == null) {
            Minecraft.getInstance().setScreen(null);
        } else if (!ClientEvents.isKeyDown(ClientEvents.OPEN_TOOL_MENU_KEYBIND)) {
            if (ConfigData.releaseToSwap) {
                this.processClick(false);
            } else {
                this.menu.close();
            }
        }
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.processClick(true);
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    protected void processClick(boolean triggeredByMouse) {
        this.menu.clickItem();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        super.render(graphics, mouseX, mouseY, partialTicks);
        poseStack.popPose();
        if (this.inventory == null) {
            return;
        }
        ItemStack inHand = this.minecraft.player.getMainHandItem();
        if (!ConfigData.isItemStackAllowed(inHand)) {
            return;
        }
        if (this.needsRecheckStacks) {
            this.cachedMenuItems.clear();
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack inSlot = this.inventory.getStackInSlot(i);
                ItemStackRadialMenuItem item = new ItemStackRadialMenuItem(this.menu, i, inSlot, (Component)Component.translatable((String)"text.toolbelt.empty")){

                    @Override
                    public boolean onClick() {
                        return RadialMenuScreen.this.trySwap(this.getSlot(), this.getStack());
                    }
                };
                item.setVisible(inSlot.getCount() > 0 || ConfigData.displayEmptySlots);
                if (inHand.getCount() > 0) {
                    if (inSlot.getCount() > 0) {
                        item.setCentralText((Component)Component.translatable((String)"text.toolbelt.swap"));
                    } else {
                        item.setCentralText((Component)Component.translatable((String)"text.toolbelt.insert"));
                    }
                } else if (inSlot.getCount() > 0) {
                    item.setCentralText((Component)Component.translatable((String)"text.toolbelt.extract"));
                } else {
                    item.setCentralText((Component)Component.translatable((String)"text.toolbelt.empty"));
                }
                this.cachedMenuItems.add(item);
            }
            this.menu.clear();
            this.menu.addAll(this.cachedMenuItems);
            this.menu.add(this.insertMenuItem);
            this.needsRecheckStacks = false;
        }
        boolean hasAddButton = false;
        if (!ConfigData.displayEmptySlots && !this.cachedMenuItems.stream().allMatch(RadialMenuItem::isVisible) && inHand.getCount() > 0) {
            hasAddButton = true;
        }
        this.insertMenuItem.setVisible(hasAddButton);
        if (this.cachedMenuItems.stream().noneMatch(RadialMenuItem::isVisible)) {
            this.menu.setCentralText((Component)Component.translatable((String)"text.toolbelt.empty"));
        } else {
            this.menu.setCentralText(null);
        }
        this.checkCycleKeybinds();
        this.menu.draw(graphics, partialTicks, mouseX, mouseY);
    }

    private boolean trySwap(int slotNumber, ItemStack itemMouseOver) {
        ItemStack inHand = this.minecraft.player.getMainHandItem();
        if (!ConfigData.isItemStackAllowed(inHand)) {
            return false;
        }
        if (inHand.getCount() > 0 || itemMouseOver.getCount() > 0) {
            SwapItems.swapItem(slotNumber, (Player)this.minecraft.player);
            PacketDistributor.sendToServer((CustomPacketPayload)new SwapItems(slotNumber), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.menu.close();
        return true;
    }

    private void checkCycleKeybinds() {
        if (ClientEvents.isKeyDown(ClientEvents.CYCLE_TOOL_MENU_LEFT_KEYBIND)) {
            if (!this.keyCycleBeforeL) {
                this.menu.cyclePrevious();
            }
            this.keyCycleBeforeL = true;
        } else {
            this.keyCycleBeforeL = false;
        }
        if (ClientEvents.isKeyDown(ClientEvents.CYCLE_TOOL_MENU_RIGHT_KEYBIND)) {
            if (!this.keyCycleBeforeR) {
                this.menu.cycleNext();
            }
            this.keyCycleBeforeR = true;
        } else {
            this.keyCycleBeforeR = false;
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

