/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.arsdelight.init.food;

import dev.xkmc.arsdelight.content.item.ADFoodItem;
import dev.xkmc.arsdelight.init.food.EffectEntry;
import dev.xkmc.arsdelight.init.registrate.ADItems;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public enum FoodType {
    FAST(true, false, false, null, ADFoodItem::new),
    NORMAL(false, false, false, null, ADFoodItem::new),
    FAST_MEAT(true, false, true, null, ADFoodItem::new),
    MEAT(false, false, true, null, ADFoodItem::new),
    DRINK(true, true, false, () -> Items.GLASS_BOTTLE, ADFoodItem::new),
    HORNED_DRINK(true, true, false, () -> ADItems.CHIMERA_HORN.get(), ADFoodItem::new),
    JELLY(false, true, false, () -> Items.GLASS_BOTTLE, ADFoodItem::new),
    BOTTLE(false, false, false, () -> Items.GLASS_BOTTLE, ADFoodItem::new),
    BOWL(false, false, false, () -> Items.BOWL, ADFoodItem::new),
    MEAT_PLATE(false, false, true, () -> Items.BOWL, ADFoodItem::new),
    MEAT_STICK(true, false, true, () -> Items.STICK, ADFoodItem::new),
    HORNED_MEAT(true, false, true, () -> ADItems.CHIMERA_HORN.get(), ADFoodItem::new);

    private final boolean fast;
    private final boolean always;
    private final boolean meat;
    @Nullable
    private final Supplier<Item> container;
    private final BiFunction<Item.Properties, FoodType, ADFoodItem> factory;

    private FoodType(boolean fast, @Nullable boolean always, boolean meat, Supplier<Item> container, BiFunction<Item.Properties, FoodType, ADFoodItem> factory) {
        this.fast = fast;
        this.always = always;
        this.meat = meat;
        this.container = container;
        this.factory = factory;
    }

    ADFoodItem build(Item.Properties prop, FoodProperties.Builder builder) {
        if (this.fast) {
            builder.fast();
        }
        if (this.always) {
            builder.alwaysEdible();
        }
        if (this.container != null) {
            builder.usingConvertsTo((ItemLike)this.container.get());
            prop.stacksTo(16);
            prop.craftRemainder(this.container.get());
        }
        prop.food(builder.build());
        return this.factory.apply(prop, this);
    }

    public ADFoodItem build(Item.Properties prop, int nut, float sat, EffectEntry ... effs) {
        FoodProperties.Builder builder = new FoodProperties.Builder();
        builder.nutrition(nut).saturationModifier(sat);
        for (EffectEntry e : effs) {
            builder.effect(e::getEffect, e.chance());
        }
        return this.build(prop, builder);
    }
}

