/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.arsdelight.events;

import com.hollingsworth.arsnouveau.api.event.ManaRegenCalcEvent;
import com.hollingsworth.arsnouveau.api.event.MaxManaCalcEvent;
import com.hollingsworth.arsnouveau.api.event.SpellDamageEvent;
import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import dev.xkmc.arsdelight.init.data.ADModConfig;
import dev.xkmc.arsdelight.init.registrate.ADEffects;
import net.minecraft.core.Holder;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;

@EventBusSubscriber(modid="arsdelight", bus=EventBusSubscriber.Bus.GAME)
public class ArsDelightServerEvents {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPlayerHeal(LivingHealEvent event) {
        MobEffectInstance shielding;
        LivingEntity e = event.getEntity();
        MobEffectInstance flourish = e.getEffect(ADEffects.FLOURISH);
        if (flourish != null) {
            ManaCap cap = CapabilityRegistry.getMana((LivingEntity)e);
            int factor = 1 << flourish.getAmplifier();
            if (cap != null) {
                double max = cap.getMaxMana();
                double maxhp = e.getMaxHealth();
                double gain = (double)event.getAmount() / maxhp * max * (double)factor;
                cap.addMana(gain);
            }
        }
        if ((shielding = e.getEffect(ADEffects.SHIELDING)) != null) {
            double factor = 1 << shielding.getAmplifier();
            double max = (Double)ADModConfig.SERVER.maxShieldingAbsorption.get() * factor;
            double old = e.getAbsorptionAmount();
            double newAb = Math.min(max, old + (double)event.getAmount() * factor);
            e.setAbsorptionAmount((float)newAb);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onDamage(LivingDamageEvent.Pre event) {
        MobEffectInstance ins;
        if (event.getSource().is(DamageTypeTags.IS_EXPLOSION) && (ins = event.getEntity().getEffect(ADEffects.BLAST_RES)) != null) {
            float res = Math.max(0.0f, 1.0f - (float)(ins.getAmplifier() + 1) * 0.2f);
            event.setNewDamage(event.getNewDamage() * res);
        }
    }

    @SubscribeEvent
    public static void spellDamagePre(SpellDamageEvent.Pre event) {
        MobEffectInstance ins = event.caster.getEffect(ADEffects.WILDEN);
        if (ins != null) {
            double factor = (Double)ADModConfig.SERVER.wildenSpellDamageBonus.get();
            event.damage *= 1.0f + (float)(ins.getAmplifier() + 1) * (float)factor;
        }
    }

    @SubscribeEvent
    public static void spellDamage(SpellDamageEvent.Post event) {
        Entity entity;
        MobEffectInstance ins = event.caster.getEffect(ADEffects.FREEZE);
        if (ins != null && (entity = event.target) instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            le.addEffect(new MobEffectInstance((Holder)ModPotions.FREEZING_EFFECT, ins.getDuration(), ins.getAmplifier()));
        }
    }

    @SubscribeEvent
    public static void maxManaCalc(MaxManaCalcEvent event) {
        MobEffectInstance ins = event.getEntity().getEffect(ADEffects.WILDEN);
        if (ins != null) {
            double config = (Double)ADModConfig.SERVER.wildenMaxManaBonus.get();
            double factor = 1.0 + (double)(ins.getAmplifier() + 1) * config;
            event.setMax((int)((double)event.getMax() * factor));
        }
    }

    @SubscribeEvent
    public static void ManaRegenCalc(ManaRegenCalcEvent event) {
        MobEffectInstance ins = event.getEntity().getEffect(ADEffects.WILDEN);
        if (ins != null) {
            double config = (Double)ADModConfig.SERVER.wildenManaRegenBonus.get();
            double factor = 1.0 + (double)(ins.getAmplifier() + 1) * config;
            event.setRegen((double)((int)(event.getRegen() * factor)));
        }
    }
}

