/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.network;

import java.util.Objects;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.craftingtweaks.CompressType;
import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.InventoryCraftingCompress;
import net.blay09.mods.craftingtweaks.InventoryCraftingDecompress;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfig;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CompressMessage
implements CustomPacketPayload {
    public static CustomPacketPayload.Type<CompressMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"craftingtweaks", (String)"compress"));
    private final int slotNumber;
    private final CompressType type;

    public CompressMessage(int slotNumber, CompressType type) {
        this.slotNumber = slotNumber;
        this.type = type;
    }

    public static CompressMessage decode(FriendlyByteBuf buf) {
        int slotNumber = buf.readInt();
        CompressType type = CompressType.values()[buf.readByte()];
        return new CompressMessage(slotNumber, type);
    }

    public static void encode(FriendlyByteBuf buf, CompressMessage message) {
        buf.writeInt(message.slotNumber);
        buf.writeByte(message.type.ordinal());
    }

    public static void handle(ServerPlayer player, CompressMessage message) {
        if (player == null) {
            return;
        }
        AbstractContainerMenu menu = player.containerMenu;
        if (menu == null) {
            return;
        }
        CompressType compressType = message.type;
        Slot mouseSlot = (Slot)menu.slots.get(message.slotNumber);
        if (!(mouseSlot.container instanceof Inventory)) {
            return;
        }
        ItemStack mouseStack = mouseSlot.getItem().copy();
        if (mouseStack.isEmpty()) {
            return;
        }
        CraftingGrid grid = CraftingTweaksProviderManager.getDefaultCraftingGrid(menu).orElse(null);
        boolean compressRequiresCraftingGrid = CraftingTweaksConfig.getActive().common.compressRequiresCraftingGrid;
        if (compressRequiresCraftingGrid && grid == null) {
            return;
        }
        if (compressType == CompressType.DECOMPRESS_ALL || compressType == CompressType.DECOMPRESS_STACK || compressType == CompressType.DECOMPRESS_ONE) {
            boolean decompressAll = compressType != CompressType.DECOMPRESS_ONE;
            block5: for (Slot slot : menu.slots) {
                int suitableSlot;
                InventoryCraftingDecompress craftingContainer;
                ItemStack result;
                if (compressType != CompressType.DECOMPRESS_ALL && slot != mouseSlot) continue;
                ItemStack slotStack = slot.getItem();
                if (!(slot.container instanceof Inventory) || !ItemStack.isSameItemSameComponents((ItemStack)slot.getItem(), (ItemStack)mouseStack) || (result = CompressMessage.assembleResult((craftingContainer = new InventoryCraftingDecompress(menu, slotStack)).asCraftInput(), craftingContainer, player)).isEmpty() || CompressMessage.isBlacklisted(result) || slotStack.isEmpty() || slotStack.getCount() < 1) continue;
                while ((suitableSlot = CompressMessage.getSlotWithEnoughSpaceToFit(player.getInventory(), result)) != -1) {
                    if (!player.getInventory().add(result)) {
                        player.drop(result, true);
                    }
                    CompressMessage.giveLeftoverItems(player, slotStack, 1);
                    slot.remove(1);
                    if (decompressAll && slot.hasItem() && slotStack.getCount() >= 1 && ItemStack.isSameItemSameComponents((ItemStack)slot.getItem(), (ItemStack)mouseStack)) continue;
                    continue block5;
                }
            }
        } else {
            switch (compressType) {
                case COMPRESS_ONE: {
                    CompressMessage.compressMouseSlot(player, menu, mouseSlot, grid, compressRequiresCraftingGrid, false);
                    break;
                }
                case COMPRESS_STACK: {
                    CompressMessage.compressMouseSlot(player, menu, mouseSlot, grid, compressRequiresCraftingGrid, true);
                    break;
                }
                case COMPRESS_ALL: {
                    CompressMessage.compressAll(player, menu, mouseSlot, grid, compressRequiresCraftingGrid);
                }
            }
        }
        menu.broadcastChanges();
    }

    private static int getSlotWithEnoughSpaceToFit(Inventory inventory, ItemStack result) {
        int firstEmptySlot = -1;
        for (int slot = 0; slot < 36; ++slot) {
            ItemStack slotStack = inventory.getItem(slot);
            if (slotStack.isEmpty() && firstEmptySlot == -1) {
                firstEmptySlot = slot;
                continue;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)result) || !slotStack.isStackable() || slotStack.getCount() + result.getCount() > inventory.getMaxStackSize(slotStack)) continue;
            return slot;
        }
        return firstEmptySlot;
    }

    private static void compressMouseSlot(ServerPlayer player, AbstractContainerMenu menu, Slot mouseSlot, CraftingGrid grid, boolean compressRequiresCraftingGrid, boolean wholeStack) {
        int maxGridSize = grid != null && compressRequiresCraftingGrid ? grid.getGridSize((Player)player, menu) : 9;
        ItemStack mouseStack = mouseSlot.getItem();
        CompressionRecipe recipe = CompressMessage.findRecipe(menu, player, mouseStack, maxGridSize);
        int recipeSize = recipe.size();
        if (recipeSize > 0) {
            int maxStackSize = recipe.result().getMaxStackSize();
            int craftsPossible = Math.min(mouseStack.getCount() / recipeSize, wholeStack ? maxStackSize : 1);
            if (craftsPossible == 0) {
                return;
            }
            int itemsToRemove = craftsPossible * recipeSize;
            CompressMessage.giveLeftoverItems(player, mouseStack, itemsToRemove);
            mouseStack.shrink(itemsToRemove);
            CompressMessage.addCraftedItemsToInventory(player, recipe.result(), craftsPossible);
        }
    }

    private static void compressAll(ServerPlayer player, AbstractContainerMenu menu, Slot mouseSlot, CraftingGrid grid, boolean compressRequiresCraftingGrid) {
        int maxGridSize = grid != null && compressRequiresCraftingGrid ? grid.getGridSize((Player)player, menu) : 9;
        ItemStack mouseStack = mouseSlot.getItem().copy();
        int totalItemCount = CompressMessage.countTotalItems(menu, mouseStack);
        CompressionRecipe recipe = CompressMessage.findRecipe(menu, player, mouseStack, maxGridSize);
        int recipeSize = recipe.size();
        if (recipeSize > 0) {
            int craftsPossible = totalItemCount / recipeSize;
            int itemsToRemove = craftsPossible * recipeSize;
            CompressMessage.removeSourceItems(player, menu, mouseStack, itemsToRemove);
            CompressMessage.addCraftedItemsToInventory(player, recipe.result(), craftsPossible);
        }
    }

    private static void giveLeftoverItems(ServerPlayer player, ItemStack slotStack, int count) {
        for (int i = 0; i < count; ++i) {
            ItemEntity itemEntity;
            ItemStack containerItem = Balm.getHooks().getCraftingRemainingItem(slotStack);
            if (player.addItem(containerItem) || (itemEntity = player.drop(containerItem, false)) == null) continue;
            itemEntity.setNoPickUpDelay();
            itemEntity.setTarget(player.getUUID());
        }
    }

    private static <T extends CraftingInput> ItemStack assembleResult(T recipeInput, RecipeCraftingHolder recipeCraftingHolder, ServerPlayer player) {
        Level level;
        RecipeManager recipeManager = Objects.requireNonNull(player.getServer()).getRecipeManager();
        RecipeHolder recipe = recipeManager.getRecipeFor(RecipeType.CRAFTING, recipeInput, level = player.level()).orElse(null);
        if (recipe != null && recipeCraftingHolder.setRecipeUsed(level, player, recipe)) {
            return ((CraftingRecipe)recipe.value()).assemble(recipeInput, (HolderLookup.Provider)level.registryAccess());
        }
        return ItemStack.EMPTY;
    }

    private static boolean isBlacklisted(ItemStack result) {
        ResourceLocation registryName = BuiltInRegistries.ITEM.getKey((Object)result.getItem());
        return CraftingTweaksConfig.getActive().common.compressDenylist.contains(registryName.toString());
    }

    private static int countTotalItems(AbstractContainerMenu menu, ItemStack sourceItem) {
        int totalItemCount = 0;
        for (Slot slot : menu.slots) {
            ItemStack slotStack = slot.getItem();
            if (!(slot.container instanceof Inventory) || !ItemStack.isSameItemSameComponents((ItemStack)slot.getItem(), (ItemStack)sourceItem)) continue;
            totalItemCount += slotStack.getCount();
        }
        return totalItemCount;
    }

    private static CompressionRecipe findRecipe(AbstractContainerMenu menu, ServerPlayer player, ItemStack exampleStack, int maxGridSize) {
        InventoryCraftingCompress exampleInventory;
        int recipeSize = 0;
        ItemStack result = ItemStack.EMPTY;
        if (maxGridSize >= 9 && !(result = CompressMessage.assembleResult((exampleInventory = new InventoryCraftingCompress(menu, 3, exampleStack)).asCraftInput(), exampleInventory, player)).isEmpty() && !CompressMessage.isBlacklisted(result)) {
            recipeSize = 9;
        }
        if (recipeSize == 0 && maxGridSize >= 4 && !(result = CompressMessage.assembleResult((exampleInventory = new InventoryCraftingCompress(menu, 2, exampleStack)).asCraftInput(), exampleInventory, player)).isEmpty() && !CompressMessage.isBlacklisted(result)) {
            recipeSize = 4;
        }
        return new CompressionRecipe(recipeSize, result);
    }

    private static void removeSourceItems(ServerPlayer player, AbstractContainerMenu menu, ItemStack sourceItem, int itemsToRemove) {
        for (Slot slot : menu.slots) {
            ItemStack slotStack = slot.getItem();
            if (!(slot.container instanceof Inventory) || !ItemStack.isSameItemSameComponents((ItemStack)slot.getItem(), (ItemStack)sourceItem)) continue;
            int removedFromSlot = Math.min(slotStack.getCount(), itemsToRemove);
            CompressMessage.giveLeftoverItems(player, slotStack, removedFromSlot);
            slot.remove(removedFromSlot);
            if ((itemsToRemove -= removedFromSlot) != 0) continue;
            break;
        }
    }

    private static void addCraftedItemsToInventory(ServerPlayer player, ItemStack result, int timesCrafted) {
        ItemStack craftedStack;
        for (int itemsCrafted = timesCrafted * result.getCount(); itemsCrafted > 0; itemsCrafted -= craftedStack.getCount()) {
            craftedStack = result.copy();
            craftedStack.setCount(Math.min(itemsCrafted, result.getMaxStackSize()));
            if (player.getInventory().add(craftedStack)) continue;
            player.drop(craftedStack, true);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    record CompressionRecipe(int size, ItemStack result) {
    }
}

