/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.api;

import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import net.blay09.mods.craftingtweaks.api.CraftingGridProvider;
import net.blay09.mods.craftingtweaks.api.InternalMethods;
import net.blay09.mods.craftingtweaks.api.RecipeMatrixMapper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;

public class CraftingTweaksAPI {
    private static final InternalMethods internalMethods = CraftingTweaksAPI.loadInternalMethods();

    private static InternalMethods loadInternalMethods() {
        try {
            return (InternalMethods)Class.forName("net.blay09.mods.craftingtweaks.api.impl.InternalMethodsImpl").getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to load Crafting Tweaks API", e);
        }
    }

    public static void registerCraftingGridProvider(CraftingGridProvider provider) {
        internalMethods.registerCraftingGridProvider(provider);
    }

    public static void unregisterCraftingGridProvider(CraftingGridProvider provider) {
        internalMethods.unregisterCraftingGridProvider(provider);
    }

    public static <C extends RecipeInput, T extends Recipe<C>> void registerRecipeMatrixMapper(Class<T> recipeClass, RecipeMatrixMapper<T> recipeMatrixMapper) {
        internalMethods.registerRecipeMatrixMapper(recipeClass, recipeMatrixMapper);
    }

    public static <C extends RecipeInput, T extends Recipe<C>> RecipeMatrixMapper<T> getRecipeMatrixMapper(Class<T> recipe) {
        return internalMethods.getRecipeMatrixMapper(recipe);
    }

    public static Optional<RecipeHolder<?>> getLastCraftedRecipe(Player player) {
        return internalMethods.getLastCraftedRecipe(player);
    }

    public static <T extends Recipe<? extends RecipeInput>> void setLastCraftedRecipe(Player player, RecipeHolder<T> recipe) {
        internalMethods.setLastCraftedRecipe(player, recipe);
    }
}

