/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import io.github.jamalam360.jamlib.JamLib;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Manifest;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class JarRenamingChecker {
    private final List<String> suspiciousJars = new ArrayList<String>();
    private final File knownSuspiciousJarsFile = new File("config/jamlib/known_suspicious_jars.txt");

    public JarRenamingChecker() {
        try {
            if (!this.knownSuspiciousJarsFile.exists()) {
                this.knownSuspiciousJarsFile.getParentFile().mkdirs();
                this.knownSuspiciousJarsFile.createNewFile();
            }
        }
        catch (IOException ignored) {
            JamLib.LOGGER.warn("Failed to create suspicious jar file list, this may cause annoying notifications.");
        }
    }

    @Nullable
    private static Manifest readManifestFromClass(Class<?> clazz) {
        try {
            String path = JarRenamingChecker.getActualJarPath(clazz);
            String manifestPath = "jar:file:" + path + "!/META-INF/MANIFEST.MF";
            return new Manifest(new URL(manifestPath).openStream());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getActualJarPath(Class<?> clazz) {
        String classFilePath = clazz.getName().replace('.', '/') + ".class";
        String path = clazz.getResource("/" + classFilePath).toString();
        if (path.startsWith("jar:file:")) {
            path = path.substring("jar:file:".length(), path.indexOf("!"));
        }
        return path;
    }

    public List<String> getSuspiciousJarsToNotifyAbout() {
        ArrayList knownSuspiciousJars = new ArrayList();
        try {
            knownSuspiciousJars.addAll(Files.readLines((File)this.knownSuspiciousJarsFile, (Charset)Charset.defaultCharset()));
        }
        catch (IOException ignored) {
            JamLib.LOGGER.warn("Failed to read known suspicious jar file list, this may cause annoying notifications.");
        }
        return this.suspiciousJars.stream().filter(jar -> !knownSuspiciousJars.contains(jar)).toList();
    }

    public void afterNotify() {
        try {
            Files.asCharSink((File)this.knownSuspiciousJarsFile, (Charset)Charset.defaultCharset(), (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)String.join((CharSequence)"\n", this.suspiciousJars));
        }
        catch (IOException ignored) {
            JamLib.LOGGER.warn("Failed to write known suspicious jar file list, this may cause annoying notifications.");
        }
    }

    public void checkJar(Class<?> clazz) {
        Manifest manifest = JarRenamingChecker.readManifestFromClass(clazz);
        if (manifest == null) {
            return;
        }
        String jarName = manifest.getMainAttributes().getValue("JamLib-File-Name");
        if (jarName == null) {
            return;
        }
        String[] split = JarRenamingChecker.getActualJarPath(clazz).split("/");
        if (!jarName.equals(split[split.length - 1])) {
            split = JarRenamingChecker.getActualJarPath(clazz).split("/");
            this.suspiciousJars.add(split[split.length - 1] + " (should be " + jarName + ")");
        }
    }
}

